#include "logindialog.h"
#include "ui_logindialog.h"
#include "oauth.h"
#include "settings.h"
#include <QDebug>

LoginDialog::LoginDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LoginDialog)
{
    ui->setupUi(this);
    oAuth * oa = new oAuth();

    ui->webView->load(QUrl(oa->getAuthUrl()));
    //this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    qDebug() << "on_pushButton_clicked";
}

LoginDialog::~LoginDialog()
{
    delete ui;
}

void LoginDialog::on_webView_loadFinished(bool )
{
    qDebug() << "on_webView_loadFinished";
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
    QUrl url(ui->webView->url());

    if(url.toString().startsWith(QString("http://peejseej.nl/")))
    {

        qDebug() << "Succes??? "+url.toString();
        QString fragment = url.fragment();
        qDebug() << "fragment: " + fragment;
        QString atstring("access_token=");
        int start = fragment.indexOf(atstring);
        start += atstring.length();
        QString token = fragment.right(fragment.length()-start);
        qDebug() << "Token:" << token;

        Settings s;
        s.setSetting("token",token);
        this->close();
    }
}

void LoginDialog::on_webView_loadStarted()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
}
