#include "leaderboard.h"
#include "ui_leaderboard.h"
#include "settings.h"

LeaderBoard::LeaderBoard(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::LeaderBoard)
{
    ui->setupUi(this);
    Settings * s = new Settings();

    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);

    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);

    ui->webView->load(QUrl("https://foursquare.com/iphone/me?view=all&scope=friends&uid="+s->getSetting("userid")));
}

LeaderBoard::~LeaderBoard()
{
    delete ui;
}

void LeaderBoard::on_webView_loadFinished(bool finished)
{
    if(finished)
        this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
}

void LeaderBoard::on_webView_loadStarted()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
}
