#include "checkinresultdialog.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QDebug>
#include <QImage>

CheckinResultDialog::CheckinResultDialog(QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    ic = new ImageCache();

    sa = new QScrollArea(this);

    mainLayout = new QVBoxLayout(sa);
    sa->setLayout(mainLayout);

    QHBoxLayout* layout = new QHBoxLayout();
    layout->addWidget(sa);
    setLayout(layout);

    setWindowTitle(tr("Checked in"));
}

void CheckinResultDialog::setResult(QList<f_checkinresult> result)
{
    this->checkinresult = result;
    qDebug() << "Result count: "<<result.size();

    for (int i = 0; i < result.size(); ++i) {
        qDebug() << "Result : "<<i << ": "+result.at(i).values.value("message");
        if(result.at(i).type=="message")
        {
            QLabel * l = new QLabel(result.at(i).values.value("message"));
            l->setWordWrap(true);
            mainLayout->addWidget(l,1,Qt::AlignLeft);
        } else if(result.at(i).type=="mayorship")
        {
            QHBoxLayout * hl = new QHBoxLayout();
            mainLayout->addLayout(hl);

            QLabel * qi = new QLabel();
            QImage image(ic->getImage(result.at(i).values.value("image")));
            qi->setPixmap(QPixmap::fromImage(image));
            hl->addWidget(qi,0,Qt::AlignLeft);

            QLabel * ql = new QLabel(result.at(i).values.value("message"));
            ql->setWordWrap(true);
            hl->addWidget(ql,10,Qt::AlignLeft);
            if(result.at(i).values.value("daysBehind")!="")
            {
                QString resultstring = "You are ";
                resultstring.append(result.at(i).values.value("daysBehind"));
                int daysbehind = result.at(i).values.value("daysBehind").toInt();
                if(daysbehind>1)
                    resultstring.append(" days");
                else
                    resultstring.append(" day");
                resultstring.append(" behind of the mayor.");
                ql->setText(ql->text()+"\n"+resultstring);
            }

        } else if(result.at(i).type=="score")
        {
            QGridLayout * gl = new QGridLayout();
            mainLayout->addLayout(gl);
            QLabel * ql = new QLabel("You received "+result.at(i).values.value("total")+" points.");
            ql->setWordWrap(true);
            gl->addWidget(ql,0,0,1,2);
            int scorecount = result.at(i).values.value("scorecount").toInt();
            for(int teller = 0; teller < scorecount; teller++)
            {
                QStringList scores = result.at(i).values.value("score"+teller).split('|');

                QLabel * qi = new QLabel();
                QImage image(ic->getImage(scores.at(1)));
                qi->setPixmap(QPixmap::fromImage(image));
                QString points = QString(" point");
                if(scores.at(0)!="1")
                    points.append("s");
                gl->addWidget(qi,teller+1,0);
                gl->addWidget(new QLabel(scores.at(0)+points),teller+1,1);
                QLabel * desc = new QLabel(scores.at(2));
                desc->setWordWrap(true);
                gl->addWidget(desc,teller+1,2);
            }
            gl->setColumnStretch(0,0);
            gl->setColumnStretch(1,0);
            gl->setColumnStretch(2,10);
        } else if(result.at(i).type=="badge")
        {
            //TODO badge
        }
    }
}
