#include "addvenueform.h"
#include "ui_addvenueform.h"
#include <QMaemo5InformationBox>

AddVenueForm::AddVenueForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::AddVenueForm)
{
    fsc = FoursquareComm::instance();
    ps = PositionSource::instance();

    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);
    ui->setupUi(this);
}

AddVenueForm::~AddVenueForm()
{
    delete ui;
}

void AddVenueForm::on_pbAdd_clicked()
{
    result = fsc->addVenue(this->ui->leName->text(),this->ui->leAddress->text(),this->ui->leCrossStreet->text(),this->ui->leCity->text(),this->ui->leState->text(),this->ui->leZip->text(),this->ui->lePhone->text(),ps->getLL());
    emit venueAdded(result);
    QMaemo5InformationBox::information(this, "<p>Venue added.</p>", QMaemo5InformationBox::DefaultTimeout);
    this->close();
}
