/**********************************************************************************************
    Copyright (C) 2009 Crohas Fabrice fcrohas@gmail.com 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CRTCom.h"
#include "dbus-strings.h"

#include <QtGui>

CRTCom * CRTCom::m_self = 0;

CRTCom::CRTCom(QObject * parent)
: IRdsText(parent)
,format("%name% %number%")
,callText("")
,timeout(30000)
,state(true)
{
    m_self = this;

    QSettings cfg;
    format = cfg.value("display/RTCom/format", format).toString();
    timeout = cfg.value("display/RTCom/timeout", timeout).toInt();
    state = cfg.value("main/RTCom", state).toBool();
    connect = false;
}


CRTCom::~CRTCom()
{
    QSettings cfg;
    cfg.setValue("display/RTCom/format", format);
    cfg.setValue("display/RTCom/timeout", timeout);
    cfg.setValue("main/RTCom", state);
}

void CRTCom::setFormat(QString value)
{
    format = value;
}

QString CRTCom::getFormat()
{
    return format;
}

void CRTCom::setTimeout(int value)
{
    timeout = value;
}

int CRTCom::getTimeout()
{
    return timeout;
}

void CRTCom::setEnable(bool value)
{
    if (value) {
       QDBusConnection::systemBus().connect( 0, RTCOM_CSD_PATH, RTCOM_CSD_IF,  "Coming", this, SLOT(slotComingChanged(QDBusObjectPath,QString)));
    } else {
       QDBusConnection::systemBus().disconnect( 0, RTCOM_CSD_PATH, RTCOM_CSD_IF,  "Coming", this, SLOT(slotComingChanged(QDBusObjectPath,QString)));
    }
    state = value;
}

bool CRTCom::getEnable()
{
    return state && connect;
}

bool CRTCom::getState()
{
    return state;
}

void CRTCom::slotComingChanged(QDBusObjectPath objectPath, QString caller)
{
    // Init caller string to send 
    callText.clear();
    callText.append(caller);
    
    bool bConnect =  QDBusConnection::systemBus().connect( 0, objectPath.path(), RTCOM_CSD_INST_IF,  "CallStatus", this, SLOT(slotCallStatus(uint,uint,uint)));
    qDebug() << "CallStatus_changed " << bConnect;
}

void CRTCom::slotCallStatus(uint state, uint ukn1, uint ukn2)
{
    if (state == 10) 
    {
        //callText.prepend(tr("Ringing ") );
        sendText(tr("Ringing ") + callText);
    }
    if (state == 0) 
    {
        //callText.prepend( );
        sendText(tr("Ended ")+callText);
    }
}

void CRTCom::sendText(QString text)
{
    emit sigChanged(text,timeout);
}

void CRTCom::setConnect(int value)
{
    if (value) {
	// If activate check before the internal plug state
	setEnable(state);
    } else {
        QDBusConnection::systemBus().disconnect( 0, RTCOM_CSD_PATH, RTCOM_CSD_IF,  "Coming", this, SLOT(slotComingChanged(QDBusObjectPath,QString)));
    }
    connect = value;
}
