/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
#ifndef QPDFIMAGE_H
#define QPDFIMAGE_H

#include <QDeclarativeItem>
extern "C" {
	#include <fitz.h>
}

class QPdfImage : public QDeclarativeItem
{
	Q_OBJECT
public:
	explicit QPdfImage(QDeclarativeItem *parent = 0);
	Q_PROPERTY(QString filepath READ filepath WRITE loadFile())
	Q_PROPERTY(bool textMode READ textMode WRITE setTextMode)
	Q_PROPERTY(int pagenum READ pagenum WRITE gotoPage NOTIFY pagenumChanged)
	Q_PROPERTY(int totalPages READ totalPages)
	Q_PROPERTY(int zoom READ zoom WRITE setZoom NOTIFY zoomChanged)
	Q_PROPERTY(QString highlightPhrase READ highlightPhrase WRITE setHighlightPhrase)
	Q_PROPERTY(bool caseSensitive READ caseSensitive WRITE setCaseSensitive)
	
	QString filepath();
	bool textMode();
	int totalPages();
	int pagenum();
	int zoom();
	int crop();
	QString highlightPhrase();
	bool caseSensitive();
	
	Q_INVOKABLE QRect curRegion();//no side effekt, therefore no slot
	
	void paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *);
	
	
signals:
	void pagenumChanged(int);
	void zoomChanged(int);
public slots:
	bool chooseFile();
	bool loadFile(QString filename);
	void setTextMode(bool tm);
	bool gotoPage(int pagenum);
	bool setZoom(int percent);
	void setHighlightPhrase(QString phrase);
	void setCaseSensitive(bool cs);
	bool searchNext(QString str);
	bool searchPrev(QString str);
	QRect prevRegion();
	QRect nextRegion();

	
private:
	QString filepath_prv;
	QImage *image;
	QString lastSearchPhrase;
	bool lastSearchCaseSensitive;
	QList<QRect> regions;
	int curRegionIdx;
	QStringList textDocument;
	QList<QRect> highlight;
	QList<int> hitCount;
	int hitOnPage;
	fz_context *context;
	fz_document *document;
	fz_pixmap *pixmap;
	fz_text_page *text_page;
	bool textMode_prv;
	int pagenum_prv;
	int totalpages_prv;
	int zoom_prv;
	QString highlightPhrase_prv;
	bool caseSensitive_prv;
	
	QStringList document2stringList();
	
};

void rgba2bgra(unsigned char *data, int size);
#endif // QPDFIMAGE_H
