import QtQuick 1.1
import frafl.PdfImage 1.0

Rectangle {
	id: mainRec
	width: 480
	height: 800
	signal showFullScreen()
	signal showNormal()
	property int refWidth: searchPrev.width;
	property int refHeight: searchPrev.height; 
	property int refPtSize: searchPrev.pointSize;
	
	focus: true
	Keys.onPressed: {
		switch(event.key){
			case Qt.Key_Left:
			case Qt.Key_Up:
			case Qt.Key_F8:
				prev.clicked();
				event.accepted = true;
				break;
			case Qt.Key_Right:
			case Qt.Key_Down:
			case Qt.Key_F7:
				next.clicked();
				event.accepted = true;
				break;
		}
		console.log(event.key)
	}

	Splash {}
	Help {id:helpScreen}

	Flickable {
		id: flick
		anchors.fill: parent;
		contentWidth: pdf.width
		contentHeight: pdf.height
		flickableDirection: Flickable.VerticalFlick
		boundsBehavior: Flickable.StopAtBounds
		property bool columnMode : colToggle.bstate;
		onColumnModeChanged: {
			if(columnMode) {
				pdf.zoom *= 0.95*width/pdf.curRegion().width;//redraws page=>curRegion changes  
				var r = pdf.curRegion();
				contentX=r.x-10;
				contentY=r.y; 
			}
		}
		PdfImage {
			id: pdf
			highlightPhrase: searchWhat.text
			caseSensitive: caseSensitiveToggle.bstate //state as bool
			textMode: txtToggle.bstate
			onPagenumChanged: {if(!flick.columnMode)/*flick.contentX=*/flick.contentY=0;}
			onZoomChanged: if(flick.columnMode){
				var r = pdf.curRegion(); 
				flick.contentX=r.x-10;
				//flick.contentY=r.y
			}
		}
		
		function prevRegion(){
			var r = pdf.prevRegion();
			contentX=r.x-10;
			contentY=r.y+r.height-0.9*height;
		}
		function nextRegion(){
			var r = pdf.nextRegion();
			contentX=r.x-10;
			contentY=r.y;
		}
		
		MouseArea {
			anchors.fill: parent
			onClicked: {
				if(mainRec.state == "")
					mainRec.state = "menus";
				else
					mainRec.state = "";
		}
	}
	}
	
	MouseArea {
		id: ma_prev
		width: parent.width
		anchors.bottom: parent.bottom
		height: flick.height/10
		onClicked: {
			next.clicked();
		}
	}
	
	MouseArea {
		id: ma_next
		width: parent.width
		anchors.top: parent.top
		height: flick.height/10
		onClicked: {
			prev.clicked();
		}
	}
	
	Flow {
		id: lwrMenu
		z : 1
		visible: false
		spacing: 5
		anchors.left: parent.left
		anchors.leftMargin: 20
		anchors.right: parent.right
		anchors.rightMargin: 20
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 30
		
		InputField {
			id: pageIpt
			height: mainRec.refHeight
			width:40
			text: pdf.pagenum
			onAccepted: {
				pdf.pagenum = pageIpt.text > pdf.totalPages ? pdf.totalPages : pageIpt.text;
				//TODO:dirty (doesn't really belong here)
				flick.columnModeChanged();
			}
			onFocusLost: {mainRec.focus = true}
		}
		
		Button {
			id : first
			text: "|<"
			width: mainRec.refWidth
			onClicked: {pdf.pagenum = 1;}
		}
		Button {
			id : prev
			width: mainRec.refWidth
			text: "<"
			onClicked: { 
				if(flick.columnMode){
					var r = pdf.curRegion();
					if(flick.contentY > r.y)
						flick.contentY -= 0.8 * flick.height;
					else
						flick.prevRegion()
				}
				else 
					pdf.pagenum = pdf.pagenum > 1 ? pdf.pagenum - 1 : pdf.pagenum;
			}
		}
		Button {
			id : next
			text: ">"
			width: mainRec.refWidth
			onClicked: { 
				if(flick.columnMode){
					var r = pdf.curRegion();
					if(flick.contentY + flick.height < r.y + r.height)
						flick.contentY += 0.8 * flick.height;
					else
						flick.nextRegion()
				} else 
					pdf.pagenum = pdf.pagenum + 1;
			}
		}
		Button {
			id : last
			width: mainRec.refWidth
			text: ">|"
			onClicked: {pdf.pagenum = pdf.totalPages}
		}
		Button {
			id : zoom_p
			text: "z+"
			onClicked: {pdf.zoom = pdf.zoom * 1.03}
		}
		Button {
			id : zoom_0
			text: "z0"
			onClicked: {pdf.zoom = 100}
		}
		Button {
			id : zoom_m
			text: "z-"
			onClicked: {pdf.zoom = pdf.zoom / 1.03}
		}
		InputField {
			id: zoomIpt
			height: mainRec.refHeight
			width:60
			text: pdf.zoom
			onAccepted: {if(text > 50) pdf.zoom = text}
			onFocusLost: {mainRec.focus = true}
		}
		Button {
			id: colToggle
			text: "  col\nmode"
			width: mainRec.refWidth
			height: mainRec.refHeight
			pointSize: mainRec.refPtSize / 2;
			onClicked: toggleState();
			mutex: txtToggle.bstate;
		}
		Button {
			id: txtToggle
			text: " text\nmode"
			width: mainRec.refWidth
			height: mainRec.refHeight
			pointSize: mainRec.refPtSize / 2;
			onClicked: toggleState();
			mutex: colToggle.bstate;
		}
		Button {
			id : close_btn
			text: "quit"
			onClicked: Qt.quit();
		}
	}
	
	Flow {
		id: uprMenu
		z : 1
		visible: false
		spacing: 5
		anchors.left: parent.left
		anchors.leftMargin: 20
		anchors.right: parent.right
		anchors.rightMargin: 20
		anchors.top: parent.top
		anchors.topMargin: 10
		
		
		Button {
			id: choose
			text: "File"
			onClicked: pdf.chooseFile();
		}
		Button {
			id: searchPrev
			text: "<?"
			onClicked: pdf.searchPrev(searchWhat.text);
		}
		Button {
			id: caseSensitiveToggle
			text: "a  \n  A"
			height: mainRec.refHeight
			pointSize: searchPrev.pointSize / 2;
			onClicked: toggleState();
		}
		Button {
			id: searchNext
			text: "?>"
			onClicked: pdf.searchNext(searchWhat.text);
		}
		InputField {
			id: searchWhat
			height: searchPrev.height
			onFocusLost: {mainRec.focus = true}
		}
		Button {
			id: flickSel
			text: "|"
			width: mainRec.refWidth
			onClicked: {
				switch(text){
					case "|" : text = "-";flick.flickableDirection = Flickable.HorizontalFlick;break;
					case "-" : text = "+";flick.flickableDirection = Flickable.HorizontalAndVerticalFlick;break;
					case "+" : text = "0";flick.interactive=false;break;
					case "0" : text = "|";flick.interactive=true;flick.flickableDirection = Flickable.VerticalFlick;break;
				};
			}
		}
		Button {
			id: fullsc
			text: "[]"
			width: mainRec.refWidth
			onClicked: {
				toggleState();
				if(state == "active")
					mainRec.showFullScreen();
				else 
					mainRec.showNormal();
			}
		}
		Button {
			id: showHelp
			text: "help"
			width: mainRec.refWidth
			height: mainRec.refHeight
			pointSize: mainRec.refPtSize * 2/3;
			onClicked: {helpScreen.visible = true}
		}
		
	}
	
	states: [
	State {
		name: "menus"
		
		PropertyChanges {target: lwrMenu; visible: true }
		PropertyChanges {target: uprMenu; visible: true }
		PropertyChanges {target: ma_prev; enabled: false }
		PropertyChanges {target: ma_next; enabled: false }
	}
	]
}
