[DBus(name="org.freedesktop.Hal.Device")]
interface Device: Object
{
    public signal void condition(string cond_name, string cond_details);

    public abstract bool get_property_boolean(string property) throws DBus.Error;
}

[DBus(name="org.maemo.flashlight_applet")]
interface FlashlightApplet: Object
{
    [DBus(name="enable")]
    public abstract void enable() throws DBus.Error;
}

[DBus(name="com.nokia.cameraui")]
interface CameraUI: Object
{
    [DBus(name="top_application")]
    public abstract void top_application() throws DBus.Error;
}


const int RESPONSE_FLASHLIGHT = 1;
const int RESPONSE_CAMERA = 2;



Device shutter;
FlashlightApplet flashlight_applet;
CameraUI camera_ui;
Gtk.Dialog dialog;


void on_cover(string name, string detail)
{
    try
    {
        if (! shutter.get_property_boolean("button.state.value"))
        {
            dialog.show_all();
            set_camera_ui_enabled(false);
        }
        else
        {
            dialog.hide();
            Timeout.add(1000, () => {
                try
                {
                    Process.spawn_command_line_async("run-standalone.sh pkill camera-ui");
                }
                catch (SpawnError e)
                {
                }
                return false;
            });
        }
    }
    catch (DBus.Error e)
    {
        stderr.printf("DBusError: %s\n", e.message);
    }
}


void on_dialog_response(int response)
{
    try
    {
        if (response == RESPONSE_FLASHLIGHT)
        {
            flashlight_applet.enable();
        }
        else if (response == RESPONSE_CAMERA)
        {
            Idle.add(() => {
                try
                {
                    camera_ui.top_application();
                }
                catch (DBus.Error e)
                {
                    stderr.printf("DBusError: %s\n", e.message);
                }
                return false;
            });
        }
    }
    catch (DBus.Error e)
    {
        stderr.printf("DBusError: %s\n", e.message);
    }

    dialog.hide();
}


Gtk.Dialog create_dialog()
{
    var dlg = new Gtk.Dialog();
    dlg.title = "What to run?";


    var flashlight_image = new Gtk.Image.from_icon_name(
        "statusarea_flashlight_on",
        Gtk.IconSize.DIALOG
    );

    var btn_flashlight = new Hildon.Button.with_text(
        Hildon.SizeType.AUTO_WIDTH | Hildon.SizeType.THUMB_HEIGHT,
        Hildon.ButtonArrangement.VERTICAL,
        "Flashlight",
        ""
    );
    btn_flashlight.set_image(flashlight_image);
    btn_flashlight.clicked.connect(() => { dlg.response(RESPONSE_FLASHLIGHT); });


    var camera_image = new Gtk.Image.from_icon_name(
        "tasklaunch_camera",
        Gtk.IconSize.DIALOG
    );

    var btn_camera = new Hildon.Button.with_text(
        Hildon.SizeType.AUTO_WIDTH | Hildon.SizeType.THUMB_HEIGHT,
        Hildon.ButtonArrangement.VERTICAL,
        "Camera",
        ""
    );
    btn_camera.set_image(camera_image);
    btn_camera.clicked.connect(() => { dlg.response(RESPONSE_CAMERA); });

    var hbox = new Gtk.HBox(true, 0);
    hbox.add(btn_flashlight);
    hbox.add(btn_camera);

    dlg.vbox.add(hbox);

    dlg.response.connect(on_dialog_response);
    dlg.delete_event.connect(() => { return true; });
    return dlg;
}


void set_camera_ui_enabled(bool enabled)
{
    if (enabled)
    {
        try
        {
            Process.spawn_command_line_async("run-standalone.sh /usr/sbin/dsmetool -t /usr/bin/camera-ui");
        }
        catch (SpawnError e)
        {
            stderr.printf("Exception: %s".printf(e.message));
        }
    }
    else
    {
        try
        {
            Process.spawn_command_line_async("run-standalone.sh /usr/sbin/dsmetool -k /usr/bin/camera-ui");
        }
        catch (SpawnError e)
        {
            stderr.printf("Exception: %s".printf(e.message));
        }
    }
}


void on_signal()
{
    set_camera_ui_enabled(true);
    Gtk.main_quit();
    stdout.printf("Stopped\n");
}


void log(string msg)
{
    var f = FileStream.open("/home/user/q", "a");
    f.printf("%s\n", msg);
}

void main(string[] args)
{
    log("Started");

    if (!Gtk.init_check(ref args))
        log("Cannot init GTK!");

    log("1");

    try
    {
    log("1.5");
        dialog = create_dialog();
    log("2");

        var system_conn = DBus.Bus.get(DBus.BusType.SYSTEM);
    log("3");

        var session_conn = DBus.Bus.get(DBus.BusType.SESSION);
    log("4");


        shutter = system_conn.get_object(
            "org.freedesktop.Hal",
            "/org/freedesktop/Hal/devices/platform_cam_shutter",
            "org.freedesktop.Hal.Device"
        ) as Device;
    log("5");


        shutter.condition.connect(on_cover);
    log("6");


        flashlight_applet = session_conn.get_object(
            "org.maemo.flashlight_applet",
            "/org/maemo/flashlight_applet",
            "org.maemo.flashlight_applet"
        ) as FlashlightApplet;
    log("7");


        camera_ui = session_conn.get_object(
            "com.nokia.cameraui",
            "/com/nokia/cameraui",
            "com.nokia.cameraui"
        ) as CameraUI;
    log("8");

        set_camera_ui_enabled(false);
    log("9");

        Posix.signal(Posix.SIGINT, on_signal);
    log("10");


        Gtk.main();
    log("11");

    }
    catch (DBus.Error e)
    {
        stderr.printf("Exception: %s".printf(e.message));

        log("Exception: %s".printf(e.message));
    }
}
