/*
 *  Flashlight applet (widget) for Maemo.
 *  Copyright (C) 2009, 2010 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "../src/flashlight_lib.h"

int main (int argc, char **argv)
{
	FlashlightContext_t *pContext = NULL;
	int intensity = 0, status = 0;

	if (flashlight_init(&pContext) < 0) {
		printf ("flashlight-test: error initializing flashlight library\n");
		return -1;
	}

	if (flashlight_open (pContext, "/dev/video0") < 0) {
		printf ("flashlight-test: error openning device\n");
		return -1;
	}

	printf ("Enabling flash LEDs in flashlight mode\n");
	if (flashlight_set_intensity(pContext, 11) < 0) {
		printf ("flashlight-test: error setting flashlight intensity to 11\n");
		return -1;
	}

	if (flashlight_get_intensity(pContext, &intensity) < 0) {
		printf ("flashlight-test: error getting flashlight intensity\n");
		return -1;
	}
	printf ("Current flashlight intensity is %d\n", intensity);

	if (flashlight_get_status(pContext, &status) < 0) {
		printf ("flashlight-test: error getting flashlight status\n");
		return -1;
	}
	printf ("Current flashlight status is 0x%04x\n", status);

	sleep(3);

	printf ("Disabling flash LEDs in flashlight mode\n");
	if (flashlight_set_intensity(pContext, 0) < 0) {
		printf ("flashlight-test: error setting flashlight intensity to 0\n");
		return -1;
	}

	if (flashlight_close (pContext) < 0) {
		printf ("flashlight-test: error closing device\n");
		return -1;
	}

	if (flashlight_deinit(pContext) < 0) {
		printf ("flashlight-test: error deinitializing flashlight library\n");
		return -1;
	}

	return 0;
}
