#include "selecticon.h"
#include "ui_selecticon.h"
#include "qsettings.h"
#include "QListWidgetItem"
#include "QFileInfo"
#include "QDirModel"
#include "QPainter"
#include <QItemDelegate>
#include <QStandardItemModel>
#include "qmaemo5rotator.h"
#include "askdialog.h"

QSettings fsettings1("cepiperez","filemanager");
QSettings fsettings2("cepiperez","filemanager_folders");


class PluginDelegate2 : public QAbstractItemDelegate {
public:
  PluginDelegate2(QObject *parent=0) : QAbstractItemDelegate(parent){}
  void paint ( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const
  {
      QRect r = option.rect;

      if(option.state & QStyle::State_Selected){
          QPixmap is1 = QPixmap("/etc/hildon/theme/images/FingerButtonPressed.png");
          painter->drawTiledPixmap(r,is1);
      }

      QPixmap pixmap = QPixmap(index.data(Qt::UserRole+1).toString());
      painter->drawPixmap(r.left()+11, r.top()+11, 48, 48, pixmap);

  }
  QSize sizeHint ( const QStyleOptionViewItem & , const QModelIndex &  ) const
  {
      return QSize(70, 70);
  }
};


selectIcon::selectIcon(QWidget *parent, QString path) :
    QDialog(parent),
    ui(new Ui::selectIcon)
{
    ui->setupUi(this);

    path1 = path;

    ui->listWidget->clear();
    QString iconSet = fsettings1.value("IconStyle", "Default").toString();


    QStringList list;

    QDir dir ( "/opt/filebox/icons/" + iconSet + "/folders/", "*" );
    dir.setFilter( QDir::Files | QDir::NoDotAndDotDot );
    QStringList entries = dir.entryList();
    for ( int i=0; i < entries.count(); ++i )
        list.append( entries.at(i) );

    for (int j=0; j < list.count(); ++j)
    {
        QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
        QString name = QFileInfo(list[j]).fileName();
        item1->setStatusTip( name );
        item1->setData(Qt::UserRole+1, "/opt/filebox/icons/" + iconSet + "/folders/" + name );
        ui->listWidget->insertItem( j, item1 );
    }

    PluginDelegate2 *pluginDelegate = new PluginDelegate2(this);
    ui->listWidget->setItemDelegate(pluginDelegate);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QCoreApplication::processEvents();
    orientationChanged();


}

selectIcon::~selectIcon()
{
    delete ui;
}

void selectIcon::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() < screenGeometry.height())
    {
        int x = ui->listWidget->count()*75;
        int i = 1;
        while ( x > 450 )
        {
            ++i;
            x = x - 450;
        }
        ui->listWidget->setMinimumHeight(i*75);
        ui->listWidget->setMaximumHeight(i*75);
    }
    else
    {
        int x = ui->listWidget->count()*75;
        int i = 1;
        while ( x > 750 )
        {
            ++i;
            x = x - 750;
        }
        ui->listWidget->setMinimumHeight(i*75);
        ui->listWidget->setMaximumHeight(i*75);
    }
    QCoreApplication::processEvents();
    this->adjustSize();

}

void selectIcon::on_listWidget_itemClicked(QListWidgetItem* item)
{
    fsettings1.remove("Subfolders");
    AskDialog* ask = new AskDialog(this, QStringList(), "Subfolders" );
    ask->exec();
    listado.clear();
    if ( fsettings1.value("Subfolders", "No").toString() == "Yes" )
    {
        getFiles( path1 );
    }
    else
    {
        listado.append(path1);
    }


    for ( int i=0; i < listado.count(); ++i )
    {
        if ( item->statusTip() == "general_folder.png" )
            fsettings2.remove( QFileInfo(listado.at(i)).fileName() );
        else
            fsettings2.setValue( QFileInfo(listado.at(i)).fileName(), item->statusTip() );
    }
    fsettings2.sync();
    //fsettings1.remove("Subfolders");
    fsettings1.sync();
    this->close();
}

void selectIcon::getFiles(QString path)
{
    listado.append( path );
    QDir dir ( path, "*" );
    dir.setFilter( QDir::Dirs | QDir::Hidden | QDir::NoDotAndDotDot );
    if ( !dir.isReadable() ) return;

    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
        getFiles( list.at(i).absoluteFilePath() );
    }

}
