#include "newfolder.h"
#include "ui_newfolder.h"
#include "qsettings.h"
#include "qfileinfo.h"
#include "qdir.h"

NewFolder::NewFolder(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::NewFolder)
{
    ui->setupUi(this);
    path1 = selected;
    ui->errorlabel->setText("");
    ui->b_accept->setEnabled(false);

}

NewFolder::~NewFolder()
{
    delete ui;
}

void NewFolder::on_b_cancel_clicked()
{
    this->close();
}


void NewFolder::on_b_accept_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("NeedToRefresh", "No");
    QString name = path1 + "/" + ui->lineEdit->text();
    QFileInfo sel = name;
    if ( (sel.isDir()) || (sel.isFile()) ) {
        ui->errorlabel->setText( tr("Cannot rename. Try another name.") );
    } else {
        QDir selected = name;
        if ( selected.mkdir(name) ) {
            //settings.setValue("NeedToRefresh", "Yes");
            this->close();
        }
    }
}

void NewFolder::on_lineEdit_textChanged(QString )
{
    if ( ui->lineEdit->text() == "" ) ui->b_accept->setEnabled(false);
    else ui->b_accept->setEnabled(true);
}
