#include <QtGui/QApplication>
#include "mainwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif
#include <QFile>
#include <QTranslator>

#include <QLocale>

QString langPath;

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    langPath = "/opt/filebox/lang/";

    // This shit returns the device language, not the current language
    //QString lang = QLocale::languageToString(QLocale::system().language());

    // Open locale file to chech current language
    QString line, lang;
    QFile data( "/etc/osso-af-init/locale" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        QTextStream out(&data);
        while ( !out.atEnd() )
        {
            line = out.readLine();
            if ( line.indexOf("export LANG") == 0 )
            {
                lang = line;
                lang.replace("export LANG=","");
            }
        }
    }
    data.close();

    // Convert en_GB to English, es_ES to Spanish...
    QLocale::setDefault(lang);
    lang = QLocale::languageToString(QLocale(lang).language());

    // Install language file
    QTranslator translator;
    if (!lang.isEmpty() && !langPath.isEmpty())
    {
        if (QFile::exists(langPath + lang + ".qm"))
        {
            translator.load(langPath + lang);
            a.installTranslator(&translator);
        }
    }

    QString folder(argv[1]);
    MainWindow* w = new MainWindow(0,folder);

    w->show();
    return a.exec();
}
