#include "extract.h"
#include "ui_extract.h"
#include "qfileinfo.h"
#include "qsettings.h"
#include <QProcess>

Extract::Extract(QWidget *parent, QString file, QStringList listado) :
    QDialog(parent),
    ui(new Ui::Extract)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);

    ui->setupUi(this);

    QCoreApplication::processEvents();

    QSettings settings("cepiperez","filemanager");

    pass = settings.value("Password","").toString();
    file1 = file;
    base = settings.value("ExtractFolder","/home/user/MyDocs").toString();
    basePath = QFileInfo(file1).path();

    zipProc = new QProcess(this);
    connect(zipProc, SIGNAL( readyReadStandardOutput() ), this, SLOT( progress() ) );
    connect(zipProc, SIGNAL( finished(int) ), this, SLOT( pfinished(int) ) );


    if ( base == basePath )
    {
        QSettings settings("cepiperez","filemanager");
        settings.setValue("NeedToRefresh","Yes");
    }


    zipProc->setWorkingDirectory(base);


    QString keep = settings.value("KeepOldFiles","No").toString();


    QFileInfo fileInfo(file1);
    QString exten = fileInfo.fileName().toLower();
    int ei = exten.lastIndexOf( "." );
    exten.remove ( 0, ei + 1 );
    if ( exten == "zip" ) {
        compresor = "unzip";
        if ( pass != "" )
        {
            if ( keep=="Yes") arguments << "-n" << "-P" << pass << file1 << "-d" << base;
            else arguments << "-o" << "-P" << pass << file1 << "-d" << base;
        }
        else
        {
            if ( keep=="Yes") arguments << "-n" << file1 << "-d" << base;
            else arguments << "-o" << file1 << "-d" << base;
        }
    } else if ( exten == "rar" ) {
        compresor = "unrar";
        if ( pass == "" ) pass="-";
        QString pass2 = "-p" + pass;
        if ( keep=="Yes") arguments << "x" << "-o-" << pass2 << "-idp" << file1 << base;
        else arguments << "x" << "-o+" << pass2 << "-idp" << file1 << base;
    } else {
        compresor = "tar";
        if ( keep=="Yes") arguments << "xkvf" << file1 << "-C" << base;
        else arguments << "xvf" << file1 << "-C" << base;
    }

    listado1.clear();
    for ( int i=0; i < listado.count(); ++i)
    {
        if ( listado.at(i) != "" ) listado1.append(listado.at(i));
    }

    ui->pbar->setMaximum( listado1.count() );
    ui->pbar->setValue(0);
    ui->label->setText("");
    progreso=0;

    zipProc->start(compresor, arguments);

}

Extract::~Extract()
{
    delete ui;
}

void Extract::progress()
{
    final=0;
    QByteArray data = zipProc->readAllStandardOutput();
    QString str = data.constData();
    str = str.toLatin1();

    if ( compresor=="tar")
    {
        int ei = str.lastIndexOf( "\n" );
        str.remove ( ei, 1 );
        ei = str.lastIndexOf( "\n" );
        str.remove ( 0, ei + 1 );
    }
    else if ( compresor=="unzip")
    {
        int ei = str.lastIndexOf( ": " );
        str.remove ( 0, ei + 1 );
        str = str.trimmed();
        str.replace(base,"");
        if ( str.indexOf("/")==0 ) str.remove(0,1);
    }
    else
    {
        int ei = str.lastIndexOf( "Extracting" );
        str.remove ( 0, ei + 11 );
        str.replace( "OK","" );
        str = str.trimmed();
        str.replace(base,"");
        if ( str.indexOf("/")==0 ) str.remove(0,1);
    }

    //ui->label->setText(str);

    ui->label->setText( tr("Extracting %1...").arg(QFileInfo(str).fileName()) );
    progreso = listado1.indexOf(str.trimmed());
    ui->pbar->setValue(progreso);

}

void Extract::pfinished(int)
{
    final=1;
    ui->pbar->setMaximum(1); ui->pbar->setValue(1);

    QByteArray data = zipProc->readAllStandardError();
    QString str = data.constData();
    str = str.toLatin1();

    if ( compresor == "tar" )
        ui->label->setText( tr("Operation finished.") );

    else if ( str.indexOf("password") > -1 )
        ui->label->setText( tr("Error extracting files. Incorrect password?") );

    else
        ui->label->setText( tr("Operation finished.") );


    //ui->label->setText(QString("%1").arg(code) );

    ui->pushButton->setText( tr("Close") );

}

void Extract::on_pushButton_clicked()
{
    if ( final==0 )
    {
        zipProc->terminate();
        final=1;
        this->close();
    }
    else
    {
        this->close();
    }

}
