#include "unzipdlg.h"
#include "ui_unzipdlg.h"
#include "home.h"
#include "qfileinfo.h"
#include "qsettings.h"

int acc;

UnzipDlg::UnzipDlg(QWidget *parent, QString path, QString file) :
    QDialog(parent),
    ui(new Ui::UnzipDlg)
{
    ui->setupUi(this);

    path1 = path;
    file1 = file;

    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Humanity").toString();

    QFileInfo fileInfo(file1);
    QString exten = fileInfo.fileName().toLower();
    int ei = exten.lastIndexOf( "." );
    exten.remove ( 0, ei + 1 );
    if ( exten == "zip" ) { ui->lineEdit->setVisible(true); ui->label->setVisible(true); }
    else if ( exten == "rar" ) { ui->lineEdit->setVisible(true); ui->label->setVisible(true); }
    else { ui->lineEdit->setVisible(false); ui->label->setVisible(false); }

    ui->button->setIcon( QPixmap("/opt/filebox/icons/" + iconSet + "/homefolder.png") );

    ui->button->setText( QFileInfo(path1).fileName() );
    if ( path1 == "/") ui->button->setText( "/" );
    ui->button->setValueText( path1 );
    if ( path1 == "/") ui->button->setValueText( "" );

    settings.setValue("ExtractFolder", path1);
    settings.remove("KeepOldFiles");

    acc=0;
}


UnzipDlg::~UnzipDlg()
{
    delete ui;
}

void UnzipDlg::reject()
{
    if ( acc==0 )
    {
        QSettings settings("cepiperez","filemanager");
        settings.remove("ExtractFolder");

    }
    emit done(Rejected);
}


void UnzipDlg::on_button_clicked()
{
    QSettings settings("cepiperez","filemanager");
    Home* hw = new Home(this, "ExtractFolder", settings.value("ExtractFolder","/home/user/MyDocs").toString());
    hw->exec();
    QString dr = settings.value("ExtractFolder","/home/user/MyDocs").toString();
    ui->button->setText( QFileInfo(dr).fileName() );
    if ( dr == "/") ui->button->setText( "/" );
    ui->button->setValueText( dr );
    if ( dr == "/") ui->button->setValueText( "" );
}

void UnzipDlg::on_pushButton_clicked()
{
    acc=0;
    this->close();
}

void UnzipDlg::on_pushButton_2_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("Password", ui->lineEdit->text());
    if ( ui->button->text() == "/" ) settings.setValue("ExtractFolder",ui->button->text());
    else settings.setValue("ExtractFolder",ui->button->valueText());
    if ( ui->checkBox->isChecked() ) settings.setValue("KeepOldFiles","Yes");
    else settings.setValue("KeepOldFiles","No");
    acc=1;
    this->close();
}
