#ifndef ME_DBUS_CONN_H
#define ME_DBUS_CONN_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <glib.h>

#define G_DEBUG_DISABLE 
#define DBUS_CONN_TYPE (dbus_conn_get_type())
#define DBUS_CONN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), DBUS_CONN, dbus_conn))
#define DBUS_CONN_GET_CLASS(obj) \
        (G_TYPE_INSTANCE_GET_CLASS ((obj), \
         DBUS_CONN_TYPE, dbus_conn_class))

typedef gboolean (*key_press_func)( guint keyval, guint state, gchar **str, gboolean *ret);

typedef struct{
    GObject parent;
    key_press_func key_press;
}dbus_conn;

typedef struct{
    GObjectClass parent_class;
}dbus_conn_class;

GType dbus_conn_get_type(void);
dbus_conn* dbus_conn_new(void);
gboolean dbus_conn_key_press( dbus_conn* obj, guint keyval, guint state, gboolean *ret, gchar **str, GError **error);
void dbus_conn_set_key_func( dbus_conn* conn, key_press_func func );

#endif
