#!/bin/sh

CFG_DIR=$HOME/.config/fceu-gui
CFG_FILE=$CFG_DIR/fceu-gui.cfg
mkdir -p $CFG_DIR 2> /dev/null
if [ ! -r $CFG_FILE ]
then
	echo "exec_path /usr/bin" > $CFG_FILE
	echo "exit_after_launch false" >> $CFG_FILE
	echo "rom_path notset" >> $CFG_FILE
	echo "sound true" >> $CFG_FILE
	echo "bpp 16" >> $CFG_FILE
	echo "fs true" >> $CFG_FILE
	echo "game_genie false" >> $CFG_FILE
	echo "tv_blur false" >> $CFG_FILE
	echo "rom2_path notset" >> $CFG_FILE
	echo "rom_path_active 1" >> $CFG_FILE
fi
# Set missing values
grep ^exec_path $CFG_FILE >/dev/null || echo "exec_path /usr/bin" >> $CFG_FILE
grep ^exit_after_launch $CFG_FILE >/dev/null || echo "exit_after_launch false" >> $CFG_FILE
grep ^rom_path $CFG_FILE >/dev/null || echo "rom_path notset" >> $CFG_FILE
grep ^sound $CFG_FILE >/dev/null || echo "sound true" >> $CFG_FILE
grep ^bpp $CFG_FILE >/dev/null || echo "bpp 16" >> $CFG_FILE
grep ^fs $CFG_FILE >/dev/null || echo "fs true" >> $CFG_FILE
grep ^game_genie $CFG_FILE >/dev/null || echo "game_genie false" >> $CFG_FILE
grep ^tv_blur $CFG_FILE >/dev/null || echo "tv_blur false" >> $CFG_FILE
grep ^rom2_path $CFG_FILE >/dev/null || echo "rom2_path notset" >> $CFG_FILE
grep ^rom_path_active $CFG_FILE >/dev/null || echo "rom_path_active 1" >> $CFG_FILE
 
cd /opt/fceu-gui/
python fceu-gui.py
