import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

# Some global variables
FceuGuiVersion = "0.0.1-1"
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
FceuGui_CfgFile = Home + '/.config/fceu-gui/fceu-gui.cfg'
P1buttons = ""
P2buttons = ""
P1joybuttons = ""
P2joybuttons = ""
BiosPath = ""
RomrcPath = ""
RomPath = ""
ExecPath = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options



class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
	# Load config
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + FceuGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/fceu"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/fceu' not found!")
        	widget = pathWindow(self)
		widget.show()
	if not os.path.isdir(self.gui_opts["rom_path"]):
		QMessageBox.critical(self, "Critical",  "rom_path" + " '" + self.gui_opts["rom_path"] + "' not found!")
       		widget = pathWindow(self)
		widget.show()

	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/fceu-gui/nes_controller.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rom_path
	ListCmd = "cd '" + self.gui_opts["rom_path"] + "';ls -1 *.zip *.ZIP *.NES *.nes 2>/dev/null|sort -f" 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	fin.close()
	romList = romList.split('\n')
	romList = romList[:-1]
	if not romList:
		romList = ['No roms found']

        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(20, 180, 750, 60))
	maxLength=63
	for Game in romList:
		space=""
		spacecount=maxLength-len(Game)
		for x in range(0,spacecount):
			space=space+" "
       		self.combo.addItem(space+Game)
	self.GameFile=[[t] for t in romList if t]

	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
           self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)


    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = str(self.GameFile[gameNbr]).strip("['']")
	global MyTeller
	global regel

	# Add all the options
	# but first, re-read all settings
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        if self.onesmutePushButton.isChecked():
		ALL_OPTS="-sound 0 " 
        else:  ALL_OPTS="-sound 1 "
        if self.gui_opts["fs"] == "false":
		ALL_OPTS = ALL_OPTS + "-fs 0 "
        else:  ALL_OPTS= ALL_OPTS + "-fs 1 "
        if self.gui_opts["game_genie"] == "false":
		ALL_OPTS = ALL_OPTS + "-gg 0 "
        else:  ALL_OPTS= ALL_OPTS + "-gg 1 "
        if self.gui_opts["tv_blur"] == "false":
        	if self.gui_opts["fs"] == "false":
			ALL_OPTS = ALL_OPTS + "-efx 0"
		else:
			ALL_OPTS = ALL_OPTS + "-efxfs 0"
	else:
        	if self.gui_opts["fs"] == "false":
			ALL_OPTS = ALL_OPTS + "-efx 2"
		else:
			ALL_OPTS = ALL_OPTS + "-efxfs 2"
	ALL_OPTS = ALL_OPTS + "-bpp " + self.gui_opts["bpp"] + " "

	if not (self.gameFile == "No roms found" ):
		# we can't do multiple commands in startDetached
		print self.gui_opts["exec_path"] + "/fceu "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile +  '"'
		QProcess.startDetached(self.gui_opts["exec_path"] + "/fceu "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile + '"' )

		if (self.gui_opts["exit_after_launch"] == "true"):
			time.sleep(5)
			os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

    def slotJoyconf(self):
        a = JoyconfWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
	AboutTxt = "<h3>Fceu-gui " + FceuGuiVersion + "</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/fceu_gui.png /><br>" \
                   "Fceu-gui is a Graphical User Interface for FCE Ultra<p> " \
                   "FCE Ultra emulates the Nintendo NES/Famicom &#174;</p>" \
                   "<p>Fceu-gui is written in PySide by <i>Arno Dekker</i> 2012<p>" \
                   "<u>Ingame keys:</u><br>" \
                   "f = toggle fullscreen<br>" \
                   "q = quit<br>" \
                   "o = save state<br>" \
                   "l = load state<br>" \
                   "r = reset" %dict()
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(794,400);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# Full screen
        self.showfsPushButton = QPushButton("full screen",self)
	self.showfsPushButton.setCheckable(True)
        grid.addWidget(self.showfsPushButton,0,0)
        self.showfsPushButton.setFont(font)
	if self.gui_opts["fs"] == "true":
            self.showfsPushButton.setChecked(True)
	# sound
        self.soundPushButton = QPushButton("sound",self)
	self.soundPushButton.setCheckable(True)
        grid.addWidget(self.soundPushButton,0,1)
        self.soundPushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
            self.soundPushButton.setChecked(True)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,0,2)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# GameGenie
        self.ggPushButton = QPushButton("GameGenie",self)
	self.ggPushButton.setCheckable(True)
        grid.addWidget(self.ggPushButton,1,0)
	if os.path.exists(Home + "/.fceultra/gg.rom"):
		if self.gui_opts["game_genie"] == "true":
			self.ggPushButton.setChecked(True)
		else:
			self.ggPushButton.setChecked(False)
	else:
		self.ggPushButton.setEnabled(False)
	# TV Blur
        self.blurPushButton = QPushButton("TV blur",self)
	self.blurPushButton.setCheckable(True)
        grid.addWidget(self.blurPushButton,1,1)
	if self.gui_opts["bpp"] == "8":
		self.blurPushButton.setEnabled(False)
	else:
		if self.gui_opts["tv_blur"] == "true":
			self.blurPushButton.setChecked(True)
		else:
			self.blurPushButton.setChecked(False)
	# BPP
	grid.addWidget(QLabel("<center>Bits per pixel (fs):</center>"), 3, 0)
        self.comboBPP = QComboBox(self)
        grid.addWidget(self.comboBPP,4,0)
	BPPs = self.listDefaultFirst("bpp",['8','16','32'])
	for bpp in BPPs:
		self.comboBPP.addItem(bpp)
	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,4,1)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("key def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,4,2)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# joystick
        #self.joystickPushButton = QPushButton("joystick",self)
	#self.joystickPushButton.setCheckable(True)
        #grid.addWidget(self.joystickPushButton,5,2)
        #self.joystickPushButton.setFont(font)
	#if self.gui_opts["extinput"] == "true":
        #    self.joystickPushButton.setChecked(True)
	# Joystick config
        #self.joyconfButton = QPushButton("joystick def",self)
        #self.joyconfButton.setFont(font)
        #grid.addWidget(self.joyconfButton,3,2)
	#QObject.connect(self.joyconfButton
	#	, SIGNAL("clicked()")
	#	, self.on_defjoy_clicked)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,6,0,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.gui_opts["sound"] = "true"
        else: self.gui_opts["sound"] = "false" 
        if self.showfsPushButton.isChecked():
           self.gui_opts["fs"] = "true"
        else: self.gui_opts["fs"] = "false" 
        if self.exitPushButton.isChecked():
           self.gui_opts["exit_after_launch"] = "true"
        else: self.gui_opts["exit_after_launch"] = "false" 
        if self.ggPushButton.isChecked():
           self.gui_opts["game_genie"] = "true"
        else: self.gui_opts["game_genie"] = "false" 
        if self.blurPushButton.isChecked():
           self.gui_opts["tv_blur"] = "true"
        else: self.gui_opts["tv_blur"] = "false" 
	self.gui_opts["bpp"] = self.comboBPP.currentText()
        if RomPath != "":
           self.gui_opts["rom_path"] = RomPath
	

        orgConfigFile = open(FceuGui_CfgFile,"r")
	try:
	        copyFile = open(FceuGui_CfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + FceuGui_CfgFile + ".old")
	else:
		# Write the copy (.old)
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(FceuGui_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + FceuGui_CfgFile)
		else:
			newConfigFile.write("# Generated by fceu-gui\n")
			for option in self.gui_opts:
				newConfigFile.write(option + " " + self.gui_opts[option] + "\n")
			newConfigFile.close()
			os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
			           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
			           string:"Configuration is succesfully saved"')


    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.gui_opts[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
	QProcess.startDetached(self.gui_opts["exec_path"] + "/fceu -inputcfg gamepad1 dummy")

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
    def on_defjoy_clicked(self):
        widget = JoykeyWindow(self)
        widget.show()

class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("Fceu-gui button config")
	LineNbr=1
        self.options = parse_config(self,Fceu_KeyCfgFile)
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,1350);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=1
	maxKeyValue=313
        self.saveKeyButton = QPushButton("SAVE",self)
        self.saveKeyButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
	grid.addWidget(QLabel("<font color=red>Save below!</font>"), 1, 0)
        grid.addWidget(self.saveKeyButton,22,0,1,3)
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
	# Add button list
	cntr=2
	for pButton in ['UP','DOWN','LEFT','RIGHT','START','COIN','BUTTON1','BUTTON2','BUTTON3','BUTTON4'\
                        ,'BUTTON5','BUTTON6','AUTOFIRE1','AUTOFIRE2','AUTOFIRE3','RESET','MENU','SERVICE'\
			,'EXIT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# UP
        self.P1UpkeySpinBox = QDoubleSpinBox()
        self.P1UpkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1UpkeySpinBox.setValue(float(self.options["UP"]))
        self.P1UpkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1UpkeySpinBox, 2, 1)
        self.P1UpButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1UpButton, 2, 2)
	# DOWN
        self.P1DownkeySpinBox = QDoubleSpinBox()
        self.P1DownkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1DownkeySpinBox.setValue(float(self.options["DOWN"]))
        self.P1DownkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1DownkeySpinBox, 3, 1)
        self.P1DownButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1DownButton, 3, 2)

	# LEFT
        self.P1LeftkeySpinBox = QDoubleSpinBox()
        self.P1LeftkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1LeftkeySpinBox.setValue(float(self.options["LEFT"]))
        self.P1LeftkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1LeftkeySpinBox, 4, 1)
        self.P1LeftButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1LeftButton, 4, 2)
	# RIGHT
        self.P1RightkeySpinBox = QDoubleSpinBox()
        self.P1RightkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1RightkeySpinBox.setValue(float(self.options["RIGHT"]))
        self.P1RightkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1RightkeySpinBox, 5, 1)
        self.P1RightButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1RightButton, 5, 2)
	# START
        self.P1StartkeySpinBox = QDoubleSpinBox()
        self.P1StartkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1StartkeySpinBox.setValue(float(self.options["START"]))
        self.P1StartkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1StartkeySpinBox, 6, 1)
        self.P1StartButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1StartButton, 6, 2)
	# COIN
        self.P1CoinkeySpinBox = QDoubleSpinBox()
        self.P1CoinkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1CoinkeySpinBox.setValue(float(self.options["COIN"]))
        self.P1CoinkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1CoinkeySpinBox, 7, 1)
        self.P1CoinButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1CoinButton, 7, 2)
	# BUTTON1
        self.P1Button1keySpinBox = QDoubleSpinBox()
        self.P1Button1keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button1keySpinBox.setValue(float(self.options["BUTTON1"]))
        self.P1Button1keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button1keySpinBox, 8, 1)
        self.P1Button1Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button1Button, 8, 2)
	# BUTTON2
        self.P1Button2keySpinBox = QDoubleSpinBox()
        self.P1Button2keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button2keySpinBox.setValue(float(self.options["BUTTON2"]))
        self.P1Button2keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button2keySpinBox, 9, 1)
        self.P1Button2Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button2Button, 9, 2)
	# BUTTON3
        self.P1Button3keySpinBox = QDoubleSpinBox()
        self.P1Button3keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button3keySpinBox.setValue(float(self.options["BUTTON3"]))
        self.P1Button3keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button3keySpinBox, 10, 1)
        self.P1Button3Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button3Button, 10, 2)
	# BUTTON4
        self.P1Button4keySpinBox = QDoubleSpinBox()
        self.P1Button4keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button4keySpinBox.setValue(float(self.options["BUTTON4"]))
        self.P1Button4keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button4keySpinBox, 11, 1)
        self.P1Button4Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button4Button, 11, 2)
	# BUTTON
        self.P1Button5keySpinBox = QDoubleSpinBox()
        self.P1Button5keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button5keySpinBox.setValue(float(self.options["BUTTON5"]))
        self.P1Button5keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button5keySpinBox, 12, 1)
        self.P1Button5Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button5Button, 12, 2)
	# BUTTON6
        self.P1Button6keySpinBox = QDoubleSpinBox()
        self.P1Button6keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Button6keySpinBox.setValue(float(self.options["BUTTON6"]))
        self.P1Button6keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Button6keySpinBox, 13, 1)
        self.P1Button6Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Button6Button, 13, 2)
	# AUTOFIRE1
        self.P1Autofire1keySpinBox = QDoubleSpinBox()
        self.P1Autofire1keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Autofire1keySpinBox.setValue(float(self.options["AUTOFIRE1"]))
        self.P1Autofire1keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Autofire1keySpinBox, 14, 1)
        self.P1Autofire1Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Autofire1Button, 14, 2)
	# AUTOFIRE2
        self.P1Autofire2keySpinBox = QDoubleSpinBox()
        self.P1Autofire2keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Autofire2keySpinBox.setValue(float(self.options["AUTOFIRE2"]))
        self.P1Autofire2keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Autofire2keySpinBox, 15, 1)
        self.P1Autofire2Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Autofire2Button, 15, 2)
	# AUTOFIRE3
        self.P1Autofire3keySpinBox = QDoubleSpinBox()
        self.P1Autofire3keySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1Autofire3keySpinBox.setValue(float(self.options["AUTOFIRE3"]))
        self.P1Autofire3keySpinBox.setDecimals(0)
        grid.addWidget(self.P1Autofire3keySpinBox, 16, 1)
        self.P1Autofire3Button = MyKeyPressed("key",self)
        grid.addWidget(self.P1Autofire3Button, 16, 2)
	# RESET
        self.P1ResetkeySpinBox = QDoubleSpinBox()
        self.P1ResetkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ResetkeySpinBox.setValue(float(self.options["RESET"]))
        self.P1ResetkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ResetkeySpinBox, 17, 1)
        self.P1ResetButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ResetButton, 17, 2)
	# MENU
        self.P1MenukeySpinBox = QDoubleSpinBox()
        self.P1MenukeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1MenukeySpinBox.setValue(float(self.options["MENU"]))
        self.P1MenukeySpinBox.setDecimals(0)
        grid.addWidget(self.P1MenukeySpinBox, 18, 1)
        self.P1MenuButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1MenuButton, 18, 2)
	# SERVICE
        self.P1ServicekeySpinBox = QDoubleSpinBox()
        self.P1ServicekeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ServicekeySpinBox.setValue(float(self.options["SERVICE"]))
        self.P1ServicekeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ServicekeySpinBox, 19, 1)
        self.P1ServiceButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ServiceButton, 19, 2)
	# EXIT
        self.P1ExitkeySpinBox = QDoubleSpinBox()
        self.P1ExitkeySpinBox.setRange(minKeyValue, maxKeyValue)
        self.P1ExitkeySpinBox.setValue(float(self.options["EXIT"]))
        self.P1ExitkeySpinBox.setDecimals(0)
        grid.addWidget(self.P1ExitkeySpinBox, 20, 1)
        self.P1ExitButton = MyKeyPressed("key",self)
        grid.addWidget(self.P1ExitButton, 20, 2)
	# SIXAXIS
        self.P1SixaxisPushButton = QPushButton("Use Sixaxis default",self)
	self.P1SixaxisPushButton.setCheckable(True)
        grid.addWidget(self.P1SixaxisPushButton,21,0,1,3)
	if self.options["SIXAXIS"] == "1":
            self.P1SixaxisPushButton.setChecked(True)

	self.setLayout(grid)

        self.connect(self.P1UpkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1DownkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1RightkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1LeftkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1StartkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1CoinkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button1keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button2keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button3keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button4keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button5keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Button6keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Autofire1keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Autofire2keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1Autofire3keySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ResetkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1MenukeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ServicekeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
        self.connect(self.P1ExitkeySpinBox, SIGNAL('valueChanged(double)'), self.change_value)
	self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
	self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
	self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
	self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
	self.connect(self.P1StartButton, SIGNAL("keyPressed"),self.P1updateStart)
	self.connect(self.P1CoinButton, SIGNAL("keyPressed"),self.P1updateCoin)
	self.connect(self.P1Button1Button, SIGNAL("keyPressed"),self.P1updateButton1)
	self.connect(self.P1Button2Button, SIGNAL("keyPressed"),self.P1updateButton2)
	self.connect(self.P1Button3Button, SIGNAL("keyPressed"),self.P1updateButton3)
	self.connect(self.P1Button4Button, SIGNAL("keyPressed"),self.P1updateButton4)
	self.connect(self.P1Button5Button, SIGNAL("keyPressed"),self.P1updateButton5)
	self.connect(self.P1Button6Button, SIGNAL("keyPressed"),self.P1updateButton6)
	self.connect(self.P1Autofire1Button, SIGNAL("keyPressed"),self.P1updateAutofire1)
	self.connect(self.P1Autofire2Button, SIGNAL("keyPressed"),self.P1updateAutofire2)
	self.connect(self.P1Autofire3Button, SIGNAL("keyPressed"),self.P1updateAutofire3)
	self.connect(self.P1ResetButton, SIGNAL("keyPressed"),self.P1updateReset)
	self.connect(self.P1MenuButton, SIGNAL("keyPressed"),self.P1updateMenu)
	self.connect(self.P1ServiceButton, SIGNAL("keyPressed"),self.P1updateService)
	self.connect(self.P1ExitButton, SIGNAL("keyPressed"),self.P1updateExit)
	self.connect(self.P1SixaxisPushButton, SIGNAL("clicked()"),self.P1updateSixaxis)
	self.connect(self.saveKeyButton, SIGNAL("clicked()"),self.SaveKeys)

    def P1updateRight(self):
        self.P1RightkeySpinBox.setValue(float(AsciiVal))

    def P1updateLeft(self):
        self.P1LeftkeySpinBox.setValue(float(AsciiVal))

    def P1updateUp(self):
        self.P1UpkeySpinBox.setValue(float(AsciiVal))

    def P1updateDown(self):
        self.P1DownkeySpinBox.setValue(float(AsciiVal))

    def P1updateStart(self):
        self.P1StartkeySpinBox.setValue(float(AsciiVal))

    def P1updateCoin(self):
        self.P1CoinkeySpinBox.setValue(float(AsciiVal))

    def P1updateButton1(self):
        self.P1Button1keySpinBox.setValue(float(AsciiVal))

    def P1updateButton2(self):
        self.P1Button2keySpinBox.setValue(float(AsciiVal))

    def P1updateButton3(self):
        self.P1Button3keySpinBox.setValue(float(AsciiVal))

    def P1updateButton4(self):
        self.P1Button4keySpinBox.setValue(float(AsciiVal))

    def P1updateButton5(self):
        self.P1Button5keySpinBox.setValue(float(AsciiVal))

    def P1updateButton6(self):
        self.P1Button6keySpinBox.setValue(float(AsciiVal))

    def P1updateAutofire1(self):
        self.P1Autofire1keySpinBox.setValue(float(AsciiVal))

    def P1updateAutofire2(self):
        self.P1Autofire2keySpinBox.setValue(float(AsciiVal))

    def P1updateAutofire3(self):
        self.P1Autofire3keySpinBox.setValue(float(AsciiVal))

    def P1updateReset(self):
        self.P1ResetkeySpinBox.setValue(float(AsciiVal))

    def P1updateMenu(self):
        self.P1MenukeySpinBox.setValue(float(AsciiVal))

    def P1updateService(self):
        self.P1ServicekeySpinBox.setValue(float(AsciiVal))

    def P1updateExit(self):
        self.P1ExitkeySpinBox.setValue(float(AsciiVal))

    def P1updateSixaxis(self):
	if self.P1SixaxisPushButton.isChecked():
           self.options["SIXAXIS"] = "1"
	else:
           self.options["SIXAXIS"] = "0"
        

    def change_value(self,event):
        # P1
        self.options["UP"] = "%.0f" % self.P1UpkeySpinBox.value()
        self.options["DOWN"] = "%.0f" % self.P1DownkeySpinBox.value()
        self.options["RIGHT"] = "%.0f" % self.P1RightkeySpinBox.value()
        self.options["LEFT"] = "%.0f" % self.P1LeftkeySpinBox.value()
        self.options["START"] = "%.0f" % self.P1StartkeySpinBox.value()
        self.options["COIN"] = "%.0f" % self.P1CoinkeySpinBox.value()
        self.options["BUTTON1"] = "%.0f" % self.P1Button1keySpinBox.value()
        self.options["BUTTON2"] = "%.0f" % self.P1Button2keySpinBox.value()
        self.options["BUTTON3"] = "%.0f" % self.P1Button3keySpinBox.value()
        self.options["BUTTON4"] = "%.0f" % self.P1Button4keySpinBox.value()
        self.options["BUTTON5"] = "%.0f" % self.P1Button5keySpinBox.value()
        self.options["BUTTON6"] = "%.0f" % self.P1Button6keySpinBox.value()
        self.options["AUTOFIRE1"] = "%.0f" % self.P1Autofire1keySpinBox.value()
        self.options["AUTOFIRE2"] = "%.0f" % self.P1Autofire2keySpinBox.value()
        self.options["AUTOFIRE3"] = "%.0f" % self.P1Autofire3keySpinBox.value()
        self.options["RESET"] = "%.0f" % self.P1ResetkeySpinBox.value()
        self.options["MENU"] = "%.0f" % self.P1MenukeySpinBox.value()
        self.options["SERVICE"] = "%.0f" % self.P1ServicekeySpinBox.value()
        self.options["EXIT"] = "%.0f" % self.P1ExitkeySpinBox.value()


class JoykeyWindow(QDialog):
    def __init__(self, parent=None):
        super(JoykeyWindow, self).__init__(parent)
	joystickAttached = os.path.exists("/dev/input/js0")
	if (joystickAttached):
        	self.setWindowTitle("Fceu-gui joystick config")
	else:
        	self.setWindowTitle("Gngeo-gui joystick config (no USB joystick found)")
	# order : A,B,C,D,START,COIN,UP,DOWN,LEFT,RIGHT
	if P1joybuttons == "":
        	self.options = parse_config(self,Fceu_KeyCfgFile)
		self.P1joyKeys=self.options["p1joy"].split(",")
	else:
		self.P1joyKeys = P1joybuttons
	if P2joybuttons == "":
        	self.options = parse_config(self,Fceu_KeyCfgFile)
		self.P2joyKeys=self.options["p2joy"].split(",")
	else:
		self.P2joyKeys = P2joybuttons
	# P1 keys
	P1Ajoykey=self.P1joyKeys[0]
	P1Bjoykey=self.P1joyKeys[1]
	P1Cjoykey=self.P1joyKeys[2]
	P1Djoykey=self.P1joyKeys[3]
	P1Startjoykey=self.P1joyKeys[4]
	P1Coinjoykey=self.P1joyKeys[5]
	P1Upjoykey=self.P1joyKeys[6]
	P1Downjoykey=self.P1joyKeys[7]
	P1Leftjoykey=self.P1joyKeys[8]
	P1Rightjoykey=self.P1joyKeys[9]
	# P2 keys
	P2Ajoykey=self.P2joyKeys[0]
	P2Bjoykey=self.P2joyKeys[1]
	P2Cjoykey=self.P2joyKeys[2]
	P2Djoykey=self.P2joyKeys[3]
	P2Startjoykey=self.P2joyKeys[4]
	P2Coinjoykey=self.P2joyKeys[5]
	P2Upjoykey=self.P2joyKeys[6]
	P2Downjoykey=self.P2joyKeys[7]
	P2Leftjoykey=self.P2joyKeys[8]
	P2Rightjoykey=self.P2joyKeys[9]
	# Layout
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.resize(750,900);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)
	minKeyValue=-1
	maxKeyValue=30
	grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
	grid.addWidget(QLabel("<center>PLAYER 2</center>"), 1, 3)
	if (joystickAttached):
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
		grid.addWidget(QLabel("<center>[pick]</center>"), 1, 4)
	# Add button list
        cntr=2
	for pButton in ['A','B','C','D','START','COIN','UP','DOWN','LEFT','RIGHT']:
		grid.addWidget(QLabel(pButton), cntr, 0)
		cntr=cntr+1
	# A-button P1
	self.P1AjoykeySpinBox = QDoubleSpinBox()
	self.P1AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1AjoykeySpinBox.setValue(float(P1Ajoykey))
	self.P1AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1AjoykeySpinBox, 2, 1)
	# A-button P2
	self.P2AjoykeySpinBox = QDoubleSpinBox()
	self.P2AjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2AjoykeySpinBox.setValue(float(P2Ajoykey))
	self.P2AjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2AjoykeySpinBox, 2, 3)
	# B-button P1
	self.P1BjoykeySpinBox = QDoubleSpinBox()
	self.P1BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1BjoykeySpinBox.setValue(float(P1Bjoykey))
	self.P1BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1BjoykeySpinBox, 3, 1)
	# B-button P2
	self.P2BjoykeySpinBox = QDoubleSpinBox()
	self.P2BjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2BjoykeySpinBox.setValue(float(P2Bjoykey))
	self.P2BjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2BjoykeySpinBox, 3, 3)
	# C-button P1
	self.P1CjoykeySpinBox = QDoubleSpinBox()
	self.P1CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CjoykeySpinBox.setValue(float(P1Cjoykey))
	self.P1CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CjoykeySpinBox, 4, 1)
	# C-button P2
	self.P2CjoykeySpinBox = QDoubleSpinBox()
	self.P2CjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CjoykeySpinBox.setValue(float(P2Cjoykey))
	self.P2CjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CjoykeySpinBox, 4, 3)
	# D-button P1
	self.P1DjoykeySpinBox = QDoubleSpinBox()
	self.P1DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DjoykeySpinBox.setValue(float(P1Djoykey))
	self.P1DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DjoykeySpinBox, 5, 1)
	# D-button P2
	self.P2DjoykeySpinBox = QDoubleSpinBox()
	self.P2DjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DjoykeySpinBox.setValue(float(P2Djoykey))
	self.P2DjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DjoykeySpinBox, 5, 3)
	# Start-button P1
	self.P1StartjoykeySpinBox = QDoubleSpinBox()
	self.P1StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1StartjoykeySpinBox.setValue(float(P1Startjoykey))
	self.P1StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1StartjoykeySpinBox, 6, 1)
	# Start-button P2
	self.P2StartjoykeySpinBox = QDoubleSpinBox()
	self.P2StartjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2StartjoykeySpinBox.setValue(float(P2Startjoykey))
	self.P2StartjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2StartjoykeySpinBox, 6, 3)
	# Coin-button P1
	self.P1CoinjoykeySpinBox = QDoubleSpinBox()
	self.P1CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1CoinjoykeySpinBox.setValue(float(P1Coinjoykey))
	self.P1CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1CoinjoykeySpinBox, 7, 1)
	# Coin-button P2
	self.P2CoinjoykeySpinBox = QDoubleSpinBox()
	self.P2CoinjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2CoinjoykeySpinBox.setValue(float(P2Coinjoykey))
	self.P2CoinjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2CoinjoykeySpinBox, 7, 3)
	# Up-key P1
	self.P1UpjoykeySpinBox = QDoubleSpinBox()
	self.P1UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1UpjoykeySpinBox.setValue(float(P1Upjoykey))
	self.P1UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1UpjoykeySpinBox, 8, 1)
	# Up-key P2
	self.P2UpjoykeySpinBox = QDoubleSpinBox()
	self.P2UpjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2UpjoykeySpinBox.setValue(float(P2Upjoykey))
	self.P2UpjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2UpjoykeySpinBox, 8, 3)
	# Down-key P1
	self.P1DownjoykeySpinBox = QDoubleSpinBox()
	self.P1DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1DownjoykeySpinBox.setValue(float(P1Downjoykey))
	self.P1DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1DownjoykeySpinBox, 9, 1)
	# Down-key P2
	self.P2DownjoykeySpinBox = QDoubleSpinBox()
	self.P2DownjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2DownjoykeySpinBox.setValue(float(P2Downjoykey))
	self.P2DownjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2DownjoykeySpinBox, 9, 3)
	# Left-key P1
	self.P1LeftjoykeySpinBox = QDoubleSpinBox()
	self.P1LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1LeftjoykeySpinBox.setValue(float(P1Leftjoykey))
	self.P1LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1LeftjoykeySpinBox, 10, 1)
	# Left-key P2
	self.P2LeftjoykeySpinBox = QDoubleSpinBox()
	self.P2LeftjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2LeftjoykeySpinBox.setValue(float(P2Leftjoykey))
	self.P2LeftjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2LeftjoykeySpinBox, 10, 3)
	# Right-key P1
	self.P1RightjoykeySpinBox = QDoubleSpinBox()
	self.P1RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P1RightjoykeySpinBox.setValue(float(P1Rightjoykey))
	self.P1RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P1RightjoykeySpinBox, 11, 1)
	# Right-key P1
	self.P2RightjoykeySpinBox = QDoubleSpinBox()
	self.P2RightjoykeySpinBox.setRange(minKeyValue, maxKeyValue)
	self.P2RightjoykeySpinBox.setValue(float(P2Rightjoykey))
	self.P2RightjoykeySpinBox.setDecimals(0)
	grid.addWidget(self.P2RightjoykeySpinBox, 11, 3)

	if (joystickAttached):
		self.P2AjoyButton = QPushButton("button",self)
		self.P1BjoyButton = QPushButton("button",self)
		self.P2BjoyButton = QPushButton("button",self)
		self.P1CjoyButton = QPushButton("button",self)
		self.P2CjoyButton = QPushButton("button",self)
		self.P1DjoyButton = QPushButton("button",self)
		self.P2DjoyButton = QPushButton("button",self)
		self.P1StartjoyButton = QPushButton("button",self)
		self.P2StartjoyButton = QPushButton("button",self)
		self.P1CoinjoyButton = QPushButton("button",self)
		self.P2CoinjoyButton = QPushButton("button",self)
		self.P1UpjoyButton = QPushButton("button",self)
		self.P2UpjoyButton = QPushButton("button",self)
		self.P1AjoyButton = QPushButton("button",self)
		self.P1RightjoyButton = QPushButton("button",self)
		self.P2RightjoyButton = QPushButton("button",self)
		self.P2LeftjoyButton = QPushButton("button",self)
		self.P1LeftjoyButton = QPushButton("button",self)
		self.P2DownjoyButton = QPushButton("button",self)
		self.P1DownjoyButton = QPushButton("button",self)
		grid.addWidget(self.P1AjoyButton, 2, 2)
		grid.addWidget(self.P2AjoyButton, 2, 4)
		grid.addWidget(self.P2RightjoyButton, 11, 4)
		grid.addWidget(self.P1RightjoyButton, 11, 2)
		grid.addWidget(self.P2LeftjoyButton, 10, 4)
		grid.addWidget(self.P2DownjoyButton, 9, 4)
		grid.addWidget(self.P1LeftjoyButton, 10, 2)
		grid.addWidget(self.P1DownjoyButton, 9, 2)
		grid.addWidget(self.P2UpjoyButton, 8, 4)
		grid.addWidget(self.P2CoinjoyButton, 7, 4)
		grid.addWidget(self.P1UpjoyButton, 8, 2)
		grid.addWidget(self.P2StartjoyButton, 6, 4)
		grid.addWidget(self.P1CoinjoyButton, 7, 2)
		grid.addWidget(self.P2DjoyButton, 5, 4)
		grid.addWidget(self.P1StartjoyButton, 6, 2)
		grid.addWidget(self.P1CjoyButton, 4, 2)
		grid.addWidget(self.P1DjoyButton, 5, 2)
		grid.addWidget(self.P2BjoyButton, 3, 4)
		grid.addWidget(self.P1BjoyButton, 3, 2)
		grid.addWidget(self.P2CjoyButton, 4, 4)

	self.setLayout(grid)
	# P1
	self.connect(self.P1AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P1RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P1RightjoyButton, SIGNAL("clicked()"),self.P1joyupdateRight)
		self.connect(self.P1LeftjoyButton, SIGNAL("clicked()"),self.P1updateLeft)
		self.connect(self.P1DownjoyButton, SIGNAL("clicked()"),self.P1updateDown)
		self.connect(self.P1UpjoyButton, SIGNAL("clicked()"),self.P1updateUp)
		self.connect(self.P1CoinjoyButton, SIGNAL("clicked()"),self.P1updateCoin)
		self.connect(self.P1StartjoyButton, SIGNAL("clicked()"),self.P1updateStart)
		self.connect(self.P1AjoyButton, SIGNAL("clicked()"),self.P1updateA)
		self.connect(self.P1BjoyButton, SIGNAL("clicked()"),self.P1updateB)
		self.connect(self.P1CjoyButton, SIGNAL("clicked()"),self.P1updateC)
		self.connect(self.P1DjoyButton, SIGNAL("clicked()"),self.P1updateD)
	# P2
	self.connect(self.P2AjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2BjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2StartjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2CoinjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2UpjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2DownjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2LeftjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	self.connect(self.P2RightjoykeySpinBox, SIGNAL('valueChanged(double)'), self.change_value_joy)
	if (joystickAttached):
		self.connect(self.P2RightjoyButton, SIGNAL("clicked()"),self.P2updateRight)
		self.connect(self.P2LeftjoyButton, SIGNAL("clicked()"),self.P2updateLeft)
		self.connect(self.P2DownjoyButton, SIGNAL("clicked()"),self.P2updateDown)
		self.connect(self.P2UpjoyButton, SIGNAL("clicked()"),self.P2updateUp)
		self.connect(self.P2CoinjoyButton, SIGNAL("clicked()"),self.P2updateCoin)
		self.connect(self.P2StartjoyButton, SIGNAL("clicked()"),self.P2updateStart)
		self.connect(self.P2AjoyButton, SIGNAL("clicked()"),self.P2updateA)
		self.connect(self.P2BjoyButton, SIGNAL("clicked()"),self.P2updateB)
		self.connect(self.P2CjoyButton, SIGNAL("clicked()"),self.P2updateC)
		self.connect(self.P2DjoyButton, SIGNAL("clicked()"),self.P2updateD)

	# P1
    def P1joyupdateRight(self):
	MyJoykeyPressed()
	self.P1RightjoykeySpinBox.setValue(float(joyVal))
    def P1updateLeft(self):
	MyJoykeyPressed()
	self.P1LeftjoykeySpinBox.setValue(float(joyVal))
    def P1updateUp(self):
	MyJoykeyPressed()
	self.P1UpjoykeySpinBox.setValue(float(joyVal))
    def P1updateDown(self):
	MyJoykeyPressed()
	self.P1DownjoykeySpinBox.setValue(float(joyVal))
    def P1updateStart(self):
	MyJoykeyPressed()
	self.P1StartjoykeySpinBox.setValue(float(joyVal))
    def P1updateCoin(self):
	MyJoykeyPressed()
	self.P1CoinjoykeySpinBox.setValue(float(joyVal))
    def P1updateA(self):
	MyJoykeyPressed()
	self.P1AjoykeySpinBox.setValue(float(joyVal))
    def P1updateB(self):
	MyJoykeyPressed()
	self.P1BjoykeySpinBox.setValue(float(joyVal))
    def P1updateC(self):
	MyJoykeyPressed()
	self.P1CjoykeySpinBox.setValue(float(joyVal))
    def P1updateD(self):
	MyJoykeyPressed()
	self.P1DjoykeySpinBox.setValue(float(joyVal))
	# P2
    def P2updateRight(self):
	MyJoykeyPressed()
	self.P2RightjoykeySpinBox.setValue(float(joyVal))
    def P2updateLeft(self):
	MyJoykeyPressed()
	self.P2LeftjoykeySpinBox.setValue(float(joyVal))
    def P2updateUp(self):
	MyJoykeyPressed()
	self.P2UpjoykeySpinBox.setValue(float(joyVal))
    def P2updateDown(self):
	MyJoykeyPressed()
	self.P2DownjoykeySpinBox.setValue(float(joyVal))
    def P2updateStart(self):
	MyJoykeyPressed()
	self.P2StartjoykeySpinBox.setValue(float(joyVal))
    def P2updateCoin(self):
	MyJoykeyPressed()
	self.P2CoinjoykeySpinBox.setValue(float(joyVal))
    def P2updateA(self):
	MyJoykeyPressed()
	self.P2AjoykeySpinBox.setValue(float(joyVal))
    def P2updateB(self):
	MyJoykeyPressed()
	self.P2BjoykeySpinBox.setValue(float(joyVal))
    def P2updateC(self):
	MyJoykeyPressed()
	self.P2CjoykeySpinBox.setValue(float(joyVal))
    def P2updateD(self):
	MyJoykeyPressed()
	self.P2DjoykeySpinBox.setValue(float(joyVal))

    def change_value_joy(self):
	# P1
	self.P1joyKeys[0] = "%.0f" % self.P1AjoykeySpinBox.value()
	self.P1joyKeys[1] = "%.0f" % self.P1BjoykeySpinBox.value()
	self.P1joyKeys[2] = "%.0f" % self.P1CjoykeySpinBox.value()
	self.P1joyKeys[3] = "%.0f" % self.P1DjoykeySpinBox.value()
	self.P1joyKeys[4] = "%.0f" % self.P1StartjoykeySpinBox.value()
	self.P1joyKeys[5] = "%.0f" % self.P1CoinjoykeySpinBox.value()
	self.P1joyKeys[6] = "%.0f" % self.P1UpjoykeySpinBox.value()
	self.P1joyKeys[7] = "%.0f" % self.P1DownjoykeySpinBox.value()
	self.P1joyKeys[8] = "%.0f" % self.P1LeftjoykeySpinBox.value()
	self.P1joyKeys[9] = "%.0f" % self.P1RightjoykeySpinBox.value()
	# P2
	self.P2joyKeys[0] = "%.0f" % self.P2AjoykeySpinBox.value()
	self.P2joyKeys[1] = "%.0f" % self.P2BjoykeySpinBox.value()
	self.P2joyKeys[2] = "%.0f" % self.P2CjoykeySpinBox.value()
	self.P2joyKeys[3] = "%.0f" % self.P2DjoykeySpinBox.value()
	self.P2joyKeys[4] = "%.0f" % self.P2StartjoykeySpinBox.value()
	self.P2joyKeys[5] = "%.0f" % self.P2CoinjoykeySpinBox.value()
	self.P2joyKeys[6] = "%.0f" % self.P2UpjoykeySpinBox.value()
	self.P2joyKeys[7] = "%.0f" % self.P2DownjoykeySpinBox.value()
	self.P2joyKeys[8] = "%.0f" % self.P2LeftjoykeySpinBox.value()
	self.P2joyKeys[9] = "%.0f" % self.P2RightjoykeySpinBox.value()
	global P1joybuttons
	global P2joybuttons
	P1joybuttons = self.P1joyKeys
	P2joybuttons = self.P2joyKeys

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
            global AsciiVal
            if (event.key() < 256):
                AsciiVal = ord(str.lower(chr(event.key())))
            if (event.key() == 16777236):
                # right
                AsciiVal = 275;
            if (event.key() == 16777234):
                # left
                AsciiVal = 276;
            if (event.key() == 16777235):
                # up
                AsciiVal = 273;
            if (event.key() == 16777237):
                # down
                AsciiVal = 274;
            if (event.key() == 16777219):
                # BS
                AsciiVal = 8;
            if (event.key() == 16777221):
                # Return
                AsciiVal = 271;
            if (event.key() == 16777248):
                # L-Shift
                AsciiVal = 304;
            if (event.key() == 16777249):
                # L-Control
                AsciiVal = 306;
            if (event.key() == 16781571):
                # L-Alt
                AsciiVal = 313;
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)

class MyJoykeyPressed(QPushButton):
    def __init__(self, parent=None):
        QPushButton.__init__(self, parent)

	global joyVal
	pipe = open('/dev/input/js0','r')
	action = []
	stopping = False
	while not stopping :
		for character in pipe.read(1):
			action += ['%02X' % ord(character)]
			if len(action) == 8:
	
				if action[6] == '01': # Button
					if action[4] == '01':
						joyVal = action[7]
						stopping = True
						break
				elif action[7] == '04': # Left Joystick left/right
					if action[4] == 'FF':
						# You pressed right on the left joystick
						joyVal = 4 #,1
						stopping = True
					elif action[4] == '01':
						# You pressed left on the left joystick
						joyVal = 4 #,1
						stopping = True
				elif action[7] == '05': # Left Joystick up/down
					if action[4] == 'FF':
						# You pressed down on the left joystick
						joyVal = 5 #,1
						stopping = True
					elif action[4] == '01':
						joyVal = 4 #,1
						# You pressed up on the left joystick 
						stopping = True

				action = []
				if stopping:
					break
			if stopping:
				break
		if stopping:
			break
	pipe.close()

 
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("Fceu-gui path configuration")
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
	if RomPath == "":
		self.romPath=self.gui_opts["rom_path"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,300);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms"), 3, 0)
	grid.addWidget(self.pushRomButton, 3, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("fceu"), 4, 0)
	grid.addWidget(self.pushExecButton, 4, 1)

	self.setLayout(grid)

	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_bios_button_clicked(self):
	global BiosPath
	BiosPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	if (not os.path.isfile(BiosPath + "/sfix.sfx")) and (BiosPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find all bios files in " + BiosPath)
	self.close()

    def on_rom_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom_homebutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button to save it!"')

    def on_rom_rootbutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button to save it!"')

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/fceu")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/fceu")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
