#ifndef SETTINGSMENU_H
#define SETTINGSMENU_H

#include <QObject>
#include <QAction>
#include <QSettings>
#include <QMenu>
#include "core.h"

class SettingsMenu : public QMenu
{
    Q_OBJECT
public:
    static SettingsMenu* instance(QWidget *parent = 0);
    enum inputStyle {AutoCapitalize, UpperCase, LowerCase, DigitOnly, FastWriteOff, FastWriteOn, QwertyOn, AlfanumOn};
    ~SettingsMenu();
    void updateMenu(int);

public slots:
    void settingsChanged();

signals:
    void inputStyleChanged(int);

private:
    explicit SettingsMenu(QWidget *parent = 0);
    static SettingsMenu* m_instance;
    static void drop();
    void qwertyEnabled();
    void alfanumEnabled();

    QAction *m_aEnableQwerty;
    QAction *m_aEnableAlfanum;
    QAction *m_aFastWrite;
    QAction *m_aAutoCapitalization;
    QAction *m_aUpperCase;
    QAction *m_aLowerCase;
    QAction *m_aDigit;

};

#endif // SETTINGSMENU_H
