#include "kb_qwerty.h"
#include "ui_kb_qwerty.h"

#define MODIFIERS_NONE 0
#define MODIFIERS_SHIFT 1
#define MODIFIERS_SYM 3
#define MODIFIERS_ACCENT 5
#define MODIFIERS_SHIFT_SYM 4
#define MODIFIERS_SHIFT_ACCENT 6
#define MODIFIERS_SYM_ACCENT 8
#define MODIFIERS_SHIFT_SYM_ACCENT 9


kb_Qwerty::kb_Qwerty(QWidget *parent,bool bStandalone) :
    Keyboard(parent),
    ui(new Ui::kb_Qwerty)
{
    ui->setupUi(this);

    SettingsMenu *menu = SettingsMenu::instance(this);
    ui->btSettings->setMenu(menu);
    connect(menu,SIGNAL(inputStyleChanged(int)),this,SLOT(settingsChanged(int)));

    m_settingsMenu = qobject_cast<SettingsMenu *> (ui->btSettings->menu());

    //Setup all connections
    foreach(QAbstractButton *button, ui->bgDirectInput->buttons())
    {
        connect(button, SIGNAL(clicked()), this, SLOT(directInputClicked()));
    }

    connect(ui->btNewLine,SIGNAL(clicked()), this, SLOT(newLineClicked()));
    connect(ui->btDel,SIGNAL(clicked()), this, SLOT(deleteClicked()));
    connect(ui->btSpace,SIGNAL(clicked()), this, SLOT(spaceClicked()));
    connect(ui->btShift, SIGNAL(clicked()), this, SLOT(maiuscClicked()));
    connect(ui->btAccent, SIGNAL(clicked()), this, SLOT(accentClicked()));
    connect(ui->btSymbol, SIGNAL(clicked()), this, SLOT(symClicked()));
    //

    m_nActiveModifiers = 0;
    setButtonsLabel();

    if(bStandalone)
    {
        ui->btSettings->setEnabled(false);
        ui->btNewLine->setEnabled(false);
        ui->btSpace->setEnabled(false);
    }
}

kb_Qwerty::~kb_Qwerty()
{
    delete ui;
}

void kb_Qwerty::setButtonsLabel()
{
    foreach(QAbstractButton *button, ui->bgDirectInput->buttons())
    {
        QString sCharset = button->property("charset").toString();

        if (m_nActiveModifiers == MODIFIERS_NONE)
        {
            //qDebug() << sCharset.at(0);
            button->setText(sCharset.at(0));
        }
        else if(m_nActiveModifiers == MODIFIERS_SHIFT)
        {
            //qDebug() << sCharset.at(1);
            button->setText(sCharset.at(1));
        }
        else if(m_nActiveModifiers == MODIFIERS_SYM)
        {
            //qDebug() << sCharset.at(2);
            button->setText(sCharset.at(2));
        }
        else if (m_nActiveModifiers == MODIFIERS_SHIFT_SYM)
        {
            //qDebug() << sCharset.at(3);
            button->setText(sCharset.at(3));
        }
        else if(m_nActiveModifiers == MODIFIERS_ACCENT)
        {
            //qDebug() << sCharset.at(4);
            button->setText(sCharset.at(4));
        }
        else if(m_nActiveModifiers == MODIFIERS_SHIFT_ACCENT)
        {
            //qDebug() << sCharset.at(4);
            button->setText(sCharset.at(4).toUpper());
        }
        else if(m_nActiveModifiers == MODIFIERS_SHIFT_SYM_ACCENT)
        {
            //qDebug() << sCharset.at(4);
            button->setText(sCharset.at(4).toUpper());
        }
        else if(m_nActiveModifiers == MODIFIERS_SYM_ACCENT)
        {
            //qDebug() << sCharset.at(4);
            button->setText(sCharset.at(4));
        }
    }
}

void kb_Qwerty::maiuscClicked(/*int nForceCheck*/)
{
//    if(nForceCheck == 0)
//    {
        QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());

        if(clickedButton->isChecked())
        {
            m_nActiveModifiers = m_nActiveModifiers + MODIFIERS_SHIFT;
        }

        else
            m_nActiveModifiers = m_nActiveModifiers - MODIFIERS_SHIFT;
//    }
//    else
//    {
//        if(nForceCheck == 1)
//        {
//            m_nActiveModifiers = m_nActiveModifiers + MODIFIERS_SHIFT;
//            ui->btShift->setChecked(true);
//        }
//        else if(ui->btShift->isChecked())
//        {
//            m_nActiveModifiers = m_nActiveModifiers - MODIFIERS_SHIFT;
//            ui->btShift->setChecked(false);
//        }
//    }

    setButtonsLabel();
}

void kb_Qwerty::symClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());

    if(clickedButton->isChecked())
        m_nActiveModifiers = m_nActiveModifiers + MODIFIERS_SYM;
    else
        m_nActiveModifiers = m_nActiveModifiers - MODIFIERS_SYM;

    setButtonsLabel();
}
void kb_Qwerty::accentClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());

    if(clickedButton->isChecked())
        m_nActiveModifiers = m_nActiveModifiers + MODIFIERS_ACCENT;
    else
        m_nActiveModifiers = m_nActiveModifiers - MODIFIERS_ACCENT;

    setButtonsLabel();
}

void kb_Qwerty::newLineClicked()
{
    emit input(Keyboard::NEWLINE,Core::Qwerty);
}

void kb_Qwerty::spaceClicked()
{
    emit input(Keyboard::SPACE,Core::Qwerty);
}

void kb_Qwerty::deleteClicked()
{
    emit input(Keyboard::DELETE,Core::Qwerty);
}

void kb_Qwerty::directInputClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    QString lastPress = clickedButton->text();

    emit input(lastPress,Core::Qwerty);
}

//void kb_Qwerty::settingsChanged(int nStyle)
//{
//    if(nStyle ==  SettingsMenu::UpperCase)
//        maiuscClicked(1);
//    if(nStyle ==  SettingsMenu::LowerCase || nStyle ==  SettingsMenu::AutoCapitalize)
//        maiuscClicked(-1);


//    Keyboard::settingsChanged(nStyle);
//}
