#include "kb_alfanum.h"
#include "ui_kb_alfanum.h"

kb_AlfaNum::kb_AlfaNum(QWidget *parent) :
        Keyboard(parent),
        ui(new Ui::kb_AlfaNum)
{
    ui->setupUi(this);

    SettingsMenu *menu = SettingsMenu::instance(this);
    ui->btSettings->setMenu(menu);
    connect(menu,SIGNAL(inputStyleChanged(int)),this,SLOT(settingsChanged(int)));

    m_settingsMenu = qobject_cast<SettingsMenu *> (ui->btSettings->menu());

    connect(ui->btOne,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btTwo,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btThree,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btFour,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btFive,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btSix,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btSeven,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btEight,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btNine,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btZero,SIGNAL(clicked()),this, SLOT(inputClicked()));
    connect(ui->btNext,SIGNAL(clicked()),this, SLOT(nextWordClicked()));
    connect(ui->btPrev,SIGNAL(clicked()),this, SLOT(prevWordClicked()));
    connect(ui->btMoveCurNext,SIGNAL(clicked()),this, SLOT(moveRightClicked()));
    connect(ui->btMoveCurPrev,SIGNAL(clicked()),this, SLOT(moveLeftClicked()));
    connect(ui->btDelChar,SIGNAL(clicked()),this, SLOT(deleteClicked()));
}

kb_AlfaNum::~kb_AlfaNum()
{
    delete ui;
}

void kb_AlfaNum::inputClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    QString lastPress = clickedButton->text().at(0);

    emit input(lastPress,Core::Alfanumeric);
}

void kb_AlfaNum::nextWordClicked()
{
    emit input(NEXTWORD,Core::Alfanumeric);
}

void kb_AlfaNum::prevWordClicked()
{
    emit input(PREVWORD,Core::Alfanumeric);
}
void kb_AlfaNum::moveRightClicked()
{
    emit input(MOVERIGHT,Core::Alfanumeric);
}

void kb_AlfaNum::moveLeftClicked()
{
    emit input(MOVELEFT,Core::Alfanumeric);
}

void kb_AlfaNum::deleteClicked()
{
    emit input(DELETE,Core::Alfanumeric);
}

