#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) 2011 Marian Klhspies <marian300@gmx.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#Importe

import sys
import time
import kissen
import pygame
import random
import logging
import subprocess
from PyQt4 import QtGui
from PyQt4.uic import loadUi


#Initialisierung der Module Pygame und Random

pygame.init()
random.seed()
#Logger einrichten
logging.basicConfig(filename = "fartyprotokoll.log",
                    level = logging.INFO,
                    format = "%(asctime)s [%(levelname)-8s] %(message)s")


#Erstellen der Mainklasse

class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)
       
        #MainWindow Initialisierung/Laden des Stylesheets
        logging.info("Farty wurde gestartet")
        self.ui=loadUi("furzkissen.ui")
        self.ui.show()
        self.ui.showFullScreen()

        #Verstecken der Wolken, Aufruf durch Signal-Slot-System des Designers
        self.ui.wolke.hide()
        self.ui.wolke2.hide()
        self.ui.wolke3.hide()
       
        #Zuordnung der Buttons mit Verweis auf deren Methoden
       
        self.ui.fart.pressed.connect(self.fartrandom)
        self.ui.close.clicked.connect(self.close2)
        self.ui.minimize.clicked.connect(self.minimize2)
        self.ui.idea.clicked.connect(self.idea2)
        self.ui.about.clicked.connect(self.about2)
        #self.ui.play.clicked.connect(self.play2)
        #self.ui.vibon.toggled.connect(self.vibOn)
        #self.ui.viboff.toggled.connect(self.vibOff)
        
        #Methoden
       
    
    def fartrandom(self):#Zufallsmechanismus für Abspielen der Furzsounds 10-81 
        fartnumber=random.randint(10,81)
        path="Furzsounds/furz0"+str(fartnumber)+".wav"
        sound=pygame.mixer.Sound(path)
        sound.play()
        pygame.time.delay(200)
        logging.info("Farty hat den Sound furz0"+str(fartnumber)+".wav gefurzt")
        
       
       
        #time.sleep(1.2) #Führt nach Mehrfachklick zu ewigem Abspielen --> deaktiviert!
       
    def close2(self):#Methode zum Schließen des Mainwindows
        logging.info("Farty wurde beendet")
        sys.exit()
        
    def minimize2(self):#Experimentell, schließt statt zu minimieren
        try:
            logging.info("Farty wurde minimiert")
            subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])
                
        except:
            logging.error("Farty konnte nicht minimiert werden!")  
         
    def idea2(self):
        logging.info("Fartys Infobox wurde aufgerufen")
        QtGui.QMessageBox.about(self, "Farty the Farter:\n",
                 "Click me, in order to let me fart.\n"
                 "I can do more than 80 different\n"
                 "kind of fart sounds\n"
                 "Have fun and keep farting ;)\n")
        
    def about2(self):
        logging.info("Fartys QtAboutBox wurde aufgerufen")
        QtGui.QMessageBox.aboutQt(self)    
        
        
    def vibOn(self):
        '''
        trigger vibration on n900
        '''
        self.rpc.rpc_run(self._MCE_SERVICE, self._MCE_REQUEST_PATH,self._MCE_REQUEST_IF,
        self._VIBRATE,rpc_args=(self._VIBRATE_PATTERN,"",""),use_system_bus=True)
        time.sleep(1)    
        fartnumber=random.randint(10,81)
        path="Furzsounds/furz0"+str(fartnumber)+".wav"
        sound=pygame.mixer.Sound(path)
        sound.play()    
    def vibOff(self):
        pass
            
    def play2(self):
        for i in range(2,20,1):
            fartnumber=random.randint(10,81)
            path="Furzsounds/furz0"+str(fartnumber)+".wav"
            sound=pygame.mixer.Sound(path)
            sound.play() 
            time.sleep(2)
            i=i+2 
            
             
            
        
        
                   
    
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())
