/*******************************************************************************

 This file is a part of Fahrplan for maemo 2009-2010

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 ============================================================================
 Name        : fahrplan_gui.h
 Author      : smurfy
 Version     : 0.1
 Description : Handles all Gui functions
 ============================================================================
 */
#ifndef _fahrplan_gui_h
#define _fahrplan_gui_h 1

#include "fahrplan_utils.h"
#include <hildon/hildon.h>
#include <hildon/hildon-button.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-picker-button.h>
#include <hildon/hildon-app-menu.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include "localisation.h"
#include <locale.h>

void onDepartureMonitorClicked(HildonButton * button, AppData *data);
void onJourneyPlannerClicked(HildonButton * button, AppData *data);
void onAboutClicked(HildonButton * button, AppData *data);
void onSelectStationClicked(HildonButton * button, AppData *data);
void onStationSelected(HildonPickerButton * button, AppData *data);
void onSearchStationClicked(GtkWidget *w, AppData *data);
void onGPSError(LocationGPSDControl *control,gint error, AppData *data);
void onGPSLocation(LocationGPSDevice *device, AppData * data);
void onGetStationByGPSClicked(HildonButton * button, AppData *data);
void onStartSearchClicked(HildonButton * button, AppData *data);
void onStartDepartureSearchClicked(HildonButton * button, AppData *data);
void onSwapClicked(HildonButton * button, AppData *data);
void onJournyResultClicked(GtkButton * button, AppData *data);
void onJournyEarlierClicked(GtkButton * button, AppData *data);
void onJournyLaterClicked(GtkButton * button, AppData *data);

void initJournyDetails(DetailInfo *details, AppData *data);
void initJournyResults(ResultInfo *result, AppData *data);
void initStationPickerForArray(GArray *result, AppData *data);
void initStationSelectorDialog(AppData *data);
void initJourneyPlanerGui(AppData *data);
void initDepartureMonitorGui(AppData *data);
void initMainWindowsMenu(AppData *data);
void initTestElements(AppData *data);
void initApplication(AppData *data);

#endif
