/*******************************************************************************

    This file is a part of Fahrplan for maemo 2009-2010

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

#ifndef SELECTSTATIONDIALOG_H
#define SELECTSTATIONDIALOG_H

#include <QDialog>
#include <QtGui>
#include <QtMaemo5>
#include <QLineEdit>
#include <qgeopositioninfo.h>
#include <qgeopositioninfosource.h>
#include <backupgpsopenstreetmap.h>

#include "parser_mobilebahnde.h"

//Use the QtMobility namespace
QTM_USE_NAMESPACE

class selectStationDialog : public QDialog
{
    Q_OBJECT

public:
    explicit selectStationDialog(QMaemo5ValueButton *sender, QGeoPositionInfo *position, parserAbstract *mainBackendParser, QSettings *mainSettings);

signals:

public slots:
    void searchButtonClicked(bool checked);
    void gpsButtonClicked(bool checked);
    void stationSelected(QString value);
    void searchReturnPressed();

private:
    QLineEdit   *searchbox;
    QPushButton *gpsButton;
    QPushButton *searchButton;
    QMaemo5ValueButton *mainSender;
    QGeoPositionInfo *myPositionInfo;
    QSettings          *settings;

    void showSelector(QStringList items);

    parserAbstract *backendParser;
};

#endif // SELECTSTATIONDIALOG_H
