#include <QtGui>
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <QStandardItemModel>
#include <QMaemo5InformationBox>

#include <errno.h>

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "qbtkeyboards.h"
#include "halkeyboards.h"

#define HAL_FDI_XML "/usr/share/hal/fdi/policy/20thirdparty/99-x11-external-keyboard.fdi"
#define TMP_FDI "/tmp/extkbd.tmp"

MainWindow::MainWindow(Window parent, bool user) :
    QDialog(0)
    ,m_parent(parent)
    ,m_languageModel(new QStandardItemModel(this))
    ,m_language1VariantModel(new QStandardItemModel(this))
    ,m_language2VariantModel(new QStandardItemModel(this))
    ,m_layoutModel(new QStandardItemModel(this))
    ,m_keyboardModel(new QStandardItemModel(this))
    ,m_languageSwitchModel(new QStandardItemModel(this))
    ,m_baseXMLParser(new BaseXMLParser(this))
    ,ui(new Ui::MainWindow)
{
    (void)user;
    ui->setupUi(this);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    //Some ugly hack from qt maemo examples
    if(parent)
    {
        setAttribute(Qt::WA_X11BypassTransientForHint);
    }


    if(!m_baseXMLParser->parse())
        return;

    ParseHalFdi();

    setLanguageModel();
    setLayoutModel();
    setLanguageSwitchModel();

    setLanguageSwitchVB();

    setKbdModelVB();



}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if (screenGeometry.width() > screenGeometry.height())
	ui->gridLayout->addWidget(ui->buttonBox, 1, 1, 1, 1);
    else
    {
	ui->gridLayout->addWidget(ui->buttonBox, 4, 0, 1, 2);
    }

    adjustSize();
}

void MainWindow::showEvent(QShowEvent *se)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    if (m_parent != None)
	XSetTransientForHint(QX11Info::display(), winId(), m_parent);

    QDialog::showEvent(se);
}

MainWindow::~MainWindow()
{
    delete ui;
    delete m_baseXMLParser;
    delete m_languageModel;
    delete m_language1VariantModel;
    delete m_language2VariantModel;
    delete m_layoutModel;
    delete m_languageSwitchModel;
    delete m_keyboardModel;
}

void MainWindow::setLayoutModel()
{
    m_layoutModel->clear();

    for (int i = 0; i < m_baseXMLParser->kbdModels().count(); ++i)
        m_layoutModel->appendRow(new QStandardItem(m_baseXMLParser->kbdModels().keys().value(i) ));

}

void MainWindow::selectKbdModel(const QString & kbdmodel)
{
    setLayoutVB(kbdmodel);
}
QStringList getLangVariant(const QString & v)
{
    QString lang=v;
    QString variant="None";
    QStringList result;
    int begin=v.indexOf('(');
    if(begin>0)
    {
        int end=v.indexOf(')',begin);
        lang=v.left(begin);
        if(end>0)
            variant=v.mid(begin+1,end-begin-1);
    }
    result.append(lang);
    result.append(variant);
    return result;
}
QString getGrpOption(const QString & s)
{
    QString result;
    QStringList options=s.split(",");
    for(int i=0;i<options.count();i++)
    {
        if(options.value(i).left(4) == "grp:")
        {
            result=options.value(i);
            break;
        }
    }
    return result;
}

void MainWindow::setLayoutVB(const QString & keyboard)
{
    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    listpicker->setModel(m_layoutModel);

    ui->vbKbdLayout->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    ui->vbKbdLayout->setPickSelector(listpicker);

    int index=-1,defindex=m_baseXMLParser->kbdModels().values().indexOf("pc105");

    QMap<QString,QString> fdiAttributes=m_halFdiProducts.value(keyboard);
    if(fdiAttributes.isEmpty())
    {
        //not set in hal fdi, try to find in base.xml
        index=m_baseXMLParser->kbdModels().keys().indexOf(keyboard);
        setFirstLanguageVB();
        setSecondLanguageVB();
    }
    else
    {
        //get data from fdi

        //set layout VB
        index=m_baseXMLParser->kbdModels().values().indexOf(fdiAttributes.value("input.x11_options.XkbModel"));

        //set language VBs
        QStringList langs=fdiAttributes.value("input.x11_options.XkbLayout").split(",");
        if(!langs.isEmpty())
        {
            QStringList lv=getLangVariant(langs.value(0));
            setFirstLanguageVB(m_baseXMLParser->kbdLangIDs().value(lv.value(0)));
            setFirstLanguageVariant(m_baseXMLParser->kbdLangIDs().value(lv.value(0)),lv.value(1));
            if(langs.count()>1)
            {
                lv=getLangVariant(langs.value(1));
                setSecondLanguageVB(m_baseXMLParser->kbdLangIDs().value(lv.value(0)));
                setSecondLanguageVariant(m_baseXMLParser->kbdLangIDs().value(lv.value(0)),lv.value(1));
            }
            else
                setSecondLanguageVB("None");
        }
        else
        {
            setFirstLanguageVB("USA");
        }
        //set switch key
        setLanguageSwitchVB();

        QString grpswitch=getGrpOption(fdiAttributes.value("input.x11_options.XkbOptions"));
        setLanguageSwitchVB(m_baseXMLParser->kbdSwitchKeys().value(grpswitch));
    }
    listpicker->setCurrentIndex(index==-1?defindex:index);

}


void MainWindow::setKbdModelVB(const QString & kbdModel)
{
    HalKeyboards halKeyboards(this);
    QBTKeyboards btkeyboards(this);

    m_keyboardModel->clear();

    for (int i = 0; i < halKeyboards.count(); ++i)
    {
        QString iconName=btkeyboards.value(halKeyboards.keys().value(i)).isEmpty()?
                    "control_keyboard":"control_bluetooth_uncategorised";
	m_keyboardModel->appendRow(new QStandardItem( QIcon::fromTheme(iconName), halKeyboards.keys().value(i) ));
    }

    for(int i = 0; i < m_halFdiProducts.count(); i++)
    {
        QString fromFdi=m_halFdiProducts.keys().value(i);
        if(halKeyboards.keys().indexOf(fromFdi) == -1)
	    m_keyboardModel->appendRow(new QStandardItem( QIcon::fromTheme("control_keyboard"), fromFdi ));

    }
    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    listpicker->setModel(m_keyboardModel);

    ui->vbExternaKeyboard->setIcon(QIcon::fromTheme("control_keyboard"));
    ui->vbExternaKeyboard->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    ui->vbExternaKeyboard->setPickSelector(listpicker);

    connect (listpicker,SIGNAL(selected(const QString &)),this,SLOT(selectKbdModel(const QString &)));
    if(kbdModel.isEmpty())
        listpicker->setCurrentIndex(0);
    else
    {
        int index=halKeyboards.keys().indexOf(kbdModel);

        listpicker->setCurrentIndex(index==-1?0:index);
    }
}
void MainWindow::setLanguageModel()
{
    m_languageModel->clear();

    for (int i = 0; i < m_baseXMLParser->kbdLangs().count(); ++i)
        m_languageModel->appendRow(new QStandardItem( m_baseXMLParser->kbdLangs().keys().value(i) ));

}

void MainWindow::setLanguageSwitchModel()
{
    m_languageSwitchModel->clear();

    for (int i = 0; i < m_baseXMLParser->kbdSwitchKeysR().count(); ++i)
        m_languageSwitchModel->appendRow(new QStandardItem( m_baseXMLParser->kbdSwitchKeysR().keys()[i] ));

    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    listpicker->setModel(m_languageSwitchModel);

    ui->vbLanguageSwitch->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    ui->vbLanguageSwitch->setPickSelector(listpicker);
}
void MainWindow::setLanguageSwitchVB(const QString & switchKey )
{

    QMaemo5ListPickSelector * listpicker = (QMaemo5ListPickSelector *)ui->vbLanguageSwitch->pickSelector();
    if(switchKey.isEmpty())
        listpicker->setCurrentIndex(0);
    else
    {
        int index=m_baseXMLParser->kbdSwitchKeysR().keys().indexOf(switchKey);
        listpicker->setCurrentIndex(index==-1?0:index);
    }
}

int MainWindow::setLanguageVariantModel(const QString & language,const QString & v,QStandardItemModel * model)
{
    QStringList variant=m_baseXMLParser->kbdLangs().value(language);
    int res=0;
    model->clear();
    model->appendRow(new QStandardItem( tr("None")));

    for (int i = 1; i < variant.count(); ++i)
    {
        model->appendRow(new QStandardItem( variant.value(i) ));
        if(variant.value(i) == v)
            res=i;
    }
    return res;
}

void MainWindow::setFirstLanguageVB(const QString & kbdLanguage)
{
    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    listpicker->setModel(m_languageModel);
    connect (listpicker,SIGNAL(selected(const QString &)),this,SLOT(setFirstLanguage(const QString &)));

    ui->vbFirstLanguage->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    ui->vbFirstLanguage->setPickSelector(listpicker);

    if(kbdLanguage.isEmpty())
        listpicker->setCurrentIndex(0);
    else
    {
        int index=m_baseXMLParser->kbdLangs().keys().indexOf(kbdLanguage);
        listpicker->setCurrentIndex(index==-1?0:index);
    }
}

void MainWindow::setSecondLanguageVB(const QString & kbdLanguage)
{
    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    listpicker->setModel(m_languageModel);
    connect (listpicker,SIGNAL(selected(const QString &)),this,SLOT(setSecondLanguage(const QString &)));

    ui->vbSecondLanguage->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    ui->vbSecondLanguage->setPickSelector(listpicker);

    if(kbdLanguage.isEmpty())
        listpicker->setCurrentIndex(0);
    else
    {
        int index=m_baseXMLParser->kbdLangs().keys().indexOf(kbdLanguage);
        listpicker->setCurrentIndex(index==-1?0:index);
    }
}

void MainWindow::setLanguageVariantVB(const QString & kbdLanguage,const QString & var,QMaemo5ValueButton * vb,QStandardItemModel * model)
{

    QMaemo5ListPickSelector * listpicker = new QMaemo5ListPickSelector();
    int v=setLanguageVariantModel(kbdLanguage,var,model);
    listpicker->setModel(model);
    vb->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    vb->setPickSelector(listpicker);
    listpicker->setCurrentIndex(v);

}

void MainWindow::setFirstLanguageVariant(const QString & language,const QString &variant)
{
    setLanguageVariantVB(language,variant,ui->vbFirstLanguageVariant,m_language1VariantModel);
}

void MainWindow::setSecondLanguageVariant(const QString & language,const QString &variant )
{
    setLanguageVariantVB(language,variant,ui->vbSecondLanguageVariant,m_language2VariantModel);
}

void MainWindow::setFirstLanguage(const QString & language )
{
    setFirstLanguageVariant(language,"None");
}

void MainWindow::setSecondLanguage(const QString & language )
{
    setSecondLanguageVariant(language,"None");
}



bool MainWindow::ParseHalFdi()
{
    QString fileName(HAL_FDI_XML);
    QFile file(fileName);

    if (!file.open(QFile::ReadOnly | QFile::Text))
    {
        QMaemo5InformationBox::information(this,
                    QString(tr("Cannot open %1 - %2")).arg(qPrintable(fileName)).arg(qPrintable(file.errorString())),QMaemo5InformationBox::NoTimeout);
        return false;
    }

    QString errorStr;
    int errorLine,errorColumn;
    QDomDocument xml;

    if (!xml.setContent(&file, false, &errorStr, &errorLine,&errorColumn))
    {
        QMaemo5InformationBox::information(this,QString(tr("Cannot parse %1 at line %2, column %3 - %4")).arg(qPrintable(fileName)).
                    arg(errorLine).arg(errorColumn).arg(qPrintable(errorStr)),QMaemo5InformationBox::NoTimeout);
        return false;
    }

    // <match key="info.capabilities" contains="input.keyboard">
    QDomNode capabilities=xml.documentElement().namedItem("device").namedItem("match");

    for(int j=0;j<capabilities.childNodes().count();j++)
    {
        QDomNode product=capabilities.childNodes().item(j);
        QMap<QString,QString> attributes;
        QString kbd=product.toElement().attribute("contains");

        for (int i = 0; i < product.childNodes().count(); ++i)
        {
            QDomElement e=product.childNodes().item(i).toElement();
            attributes.insert(e.attribute("key"),e.text());

        }
        m_halFdiProducts.insert(kbd,attributes);

        //fill data used later to produce new fdi
        QStringList kbdProps;

        //add empty properties
        for(int k =0;k<KBD_NUM_ATTR;k++)
            kbdProps.append("");

        kbdProps[0]=attributes.value("input.x11_options.XkbModel");

        QStringList langs=attributes.value("input.x11_options.XkbLayout").split(",");
        if(!langs.isEmpty())
        {
            QStringList lv=getLangVariant(langs.value(0));
            kbdProps[1]=lv.value(0);
            kbdProps[2]=lv.value(1);

            if(langs.count()>1)
            {
                lv=getLangVariant(langs.value(1));
                kbdProps[3]=lv.value(0);
                kbdProps[4]=lv.value(1);
            }

        }
        kbdProps[5]=getGrpOption(attributes.value("input.x11_options.XkbOptions"));

        m_Keyboards.insert(kbd,kbdProps);
    }
    return true;
}


void MainWindow::on_vbExternaKeyboard_clicked()
{
    saveCurrentKeyboard();
}

void MainWindow::saveCurrentKeyboard()
{
    QString kbd=ui->vbExternaKeyboard->valueText();
    if(!kbd.isEmpty())
    {
        QStringList kbdProps;
        int index=0;

        //Layout
        kbdProps.append(m_baseXMLParser->kbdModels().value(ui->vbKbdLayout->valueText()));

        //1st lang
        index=m_baseXMLParser->kbdLangIDs().values().indexOf( ui->vbFirstLanguage->valueText());
        kbdProps.append(m_baseXMLParser->kbdLangIDs().keys().value(index));
        //1st lang variant
        kbdProps.append(ui->vbFirstLanguageVariant->valueText());

        //2nd lang
        index=m_baseXMLParser->kbdLangIDs().values().indexOf( ui->vbSecondLanguage->valueText());
        kbdProps.append(m_baseXMLParser->kbdLangIDs().keys().value(index));
        //2nd lang variant
        kbdProps.append(ui->vbSecondLanguageVariant->valueText());

        //Switch key(s)
        kbdProps.append(m_baseXMLParser->kbdSwitchKeysR().value(ui->vbLanguageSwitch->valueText()));

        qDebug() << kbd;
        for(int i=0;i<kbdProps.count();i++)
            qDebug()<<kbdProps.value(i);
        m_Keyboards.insert(kbd,kbdProps);
    }
}
#define FDI_HDR \
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r" \
"<deviceinfo version=\"0.2\">\r" \
"   <device>\r" \
"       <match key=\"info.capabilities\" contains=\"input.keyboard\">\r"

#define FDI_TRLR \
"       </match>\r" \
"   </device>\r" \
"</deviceinfo>"

#define FDI_PRODUCT \
"           <match key=\"info.product\" contains=\"%1\">\r" \
"               <merge key=\"input.x11_options.XkbModel\" type=\"string\">%2</merge>\r" \
"               <merge key=\"input.x11_options.XkbLayout\" type=\"string\">%3</merge>\r" \
"               <merge key=\"input.x11_options.XkbOptions\" type=\"string\">%4</merge>\r" \
"           </match>\r"


void MainWindow::makeFdi()
{
    QFile file(TMP_FDI);

    if (!file.open(QFile::WriteOnly | QFile::Truncate | QFile::Text))
    {
        QMaemo5InformationBox::information(this,
                    QString(tr("Cannot open %1 - %2")).arg(qPrintable(file.fileName())).arg(qPrintable(file.errorString())),QMaemo5InformationBox::NoTimeout);
        return;
    }
    file.write(FDI_HDR);
    for(int i=0;i< m_Keyboards.count();i++)
    {
        QString product=m_Keyboards.keys().value(i);
        QStringList kbdProps=m_Keyboards[product];

        QString layouts;
        layouts=kbdProps[1];

        if(kbdProps[2]!="None")
            layouts+="("+kbdProps[2]+")";

        if(kbdProps[3]!="None")
        {
            layouts+=","+kbdProps[3];

            if(kbdProps[4]!="None")
            {
                layouts+="("+kbdProps[4]+")";
            }
        }

        QString options=kbdProps[5]+",caps:shiftlock";

	file.write(QString(FDI_PRODUCT).arg(product).arg(kbdProps[0]).arg(layouts).arg(options).toLatin1());

    }
    file.write(FDI_TRLR);
}

#define TMP_HAL_FILE "/tmp/extkbd.lshal.tmp"
void MainWindow::applyKbdMap()
{

    HalKeyboards kbds(this);
    for(int i=0;i<kbds.count();i++)
    {
	system(QString("sudo /usr/libexec/extkbd-set %1").arg(kbds.values().value(i)).toLatin1());
    }
}

void MainWindow::on_buttonBox_accepted()
{
    QMaemo5InformationBox::information(this, QString(tr("Saving...")));
    QApplication::processEvents();

    saveCurrentKeyboard();
    QApplication::processEvents();
    makeFdi();
    QApplication::processEvents();
    system("sudo /usr/libexec/extkbd-set");
    QApplication::processEvents();

    applyKbdMap();
    accept();
}


