#ifndef BASEXMLPARSER_H
#define BASEXMLPARSER_H

#include <QWidget>
#include <QMap>

class BaseXMLParser:public QObject
{
    Q_OBJECT

public:
    BaseXMLParser(QWidget * parent):
        QObject(0),
        m_parent(parent){};
    bool parse();

    const QMap< QString, QString> & kbdModels(){return m_kbdModels;};
    const QMap< QString, QStringList > kbdLangs(){return m_kbdLanguages;};
    const QMap< QString, QString > & kbdLangIDs(){return m_kbdLanguageIDs;};
    const QMap< QString, QString > & kbdSwitchKeys(){return m_switchKeys;};
    const QMap< QString, QString > & kbdSwitchKeysR(){return m_rswitchKeys;};

protected:
    QWidget * m_parent;

    //key - description, value - keyboard id
    QMap< QString, QString> m_kbdModels;

    // key - description, value [ id,variant1id,variant2id,... ]
    QMap< QString, QStringList > m_kbdLanguages;

    //key - language id, value - description
    QMap< QString, QString > m_kbdLanguageIDs;

    //key - group id, value - description
    QMap< QString, QString > m_switchKeys;

    //key - description, value group id
    QMap< QString, QString > m_rswitchKeys;

};

#endif // BASEXMLPARSER_H
