#include <QString>
#include <QFile>
#include <QMaemo5InformationBox>
#include <QDomDocument>
#include <QDebug>

#include "basexmlparser.h"

#define XKB_BASE_XML "/usr/share/X11/xkb/rules/base.xml"

bool BaseXMLParser::parse()
{
    QString fileName(XKB_BASE_XML);
    QFile file(fileName);

    if (!file.open(QFile::ReadOnly | QFile::Text))
    {
        QMaemo5InformationBox::information(m_parent,
                    QString(tr("Cannot open %1 - %2")).arg(qPrintable(fileName)).arg(qPrintable(file.errorString())),QMaemo5InformationBox::NoTimeout);
        return false;
    }

    QString errorStr;
    int errorLine,errorColumn;
    QDomDocument xml;

    if (!xml.setContent(&file, false, &errorStr, &errorLine,&errorColumn))
    {
        QMaemo5InformationBox::information(m_parent,QString(tr("Cannot parse %1 at line %2, column %3 - %4")).arg(qPrintable(fileName)).
                    arg(errorLine).arg(errorColumn).arg(qPrintable(errorStr)),QMaemo5InformationBox::NoTimeout);
        return false;
    }

    //Parse Keyboard Models
    QDomNode modelList=xml.documentElement().namedItem("modelList");

    for (int i = 0; i < modelList.childNodes().count(); ++i)
    {
        QDomNode modelNode=modelList.childNodes().item(i).namedItem("configItem");
        m_kbdModels.insert(modelNode.namedItem("description").toElement().text(),modelNode.namedItem("name").toElement().text());
    }

    //Parse Language IDs
    QDomNode languageList=xml.documentElement().namedItem("layoutList");

    for (int i = 0; i < languageList.childNodes().count(); ++i)
    {
        QDomNode modelNode=languageList.childNodes().item(i).namedItem("configItem");
        QDomNode variantListNode=languageList.childNodes().item(i).namedItem("variantList");


        QStringList variants;
        QString name=modelNode.namedItem("name").toElement().text();
        QString description=modelNode.namedItem("description").toElement().text();

        variants.append(name);
        m_kbdLanguageIDs.insert(name,description);

        for(int j=0;j<variantListNode.childNodes().count();j++)
            variants.append(variantListNode.childNodes().item(j).namedItem("configItem").namedItem("name").toElement().text());

        m_kbdLanguages.insert(description,variants);
    }

    //Parse switch key combinatons
    QDomNode optionList=xml.documentElement().namedItem("optionList");
    for(int i=0;i<optionList.childNodes().count();i++)
    {
        QDomNode groupNode= optionList.childNodes().item(i);
        QDomNode configItemNode=groupNode.namedItem("configItem");

        if(configItemNode.namedItem("name").toElement().text() != "grp")
            continue;

        for(int j=0;j<groupNode.childNodes().count();j++)
        {
            QDomElement optionNode=groupNode.childNodes().item(j).toElement();
            //skip group id

            QDomNode configNode=optionNode.namedItem("configItem");

            m_switchKeys.insert(
                                    configNode.namedItem("name").toElement().text(),
                                    configNode.namedItem("description").toElement().text()
                                );
            m_rswitchKeys.insert(
                                    configNode.namedItem("description").toElement().text(),
                                    configNode.namedItem("name").toElement().text()
                                );
        }
        break;
    }
    return true;

}
