// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>
#include <QFileDialog>
#include <QFileInfo>
#include <readonlydelegate.h>
#include <QtCore/QCoreApplication>
#include <QMessageBox>
#include <QtDBus>
#include <cmath>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    //connect(ui->pushButton_Exit,SIGNAL(clicked()),this,SLOT(close()));//Exit button
    connect(&dirWindow,SIGNAL(hidden()),this,SLOT(getPath()));
    connect(&dirWindow,SIGNAL(hiddenDoNothing()),this,SLOT(show()));
    connect(&hForm,SIGNAL(hiddenDoNothing()),this,SLOT(show()));
    ///load the data model
    model.setColumnCount(3);
    model.setHeaderData(0,Qt::Horizontal,"Filename");
    model.setHeaderData(1,Qt::Horizontal,"Ext");
    model.setHeaderData(2,Qt::Horizontal,"Path");
    ui->tableView->setModel(&model);
    //ui->tableView->setDragDropMode(QAbstractItemView::InternalMove);
    //ui->tableView->setDragEnabled(true);
    //ui->tableView->setDragDropOverwriteMode(false);
    ui->tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableView->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->tableView->horizontalHeader()->setStretchLastSection(true);
    ui->tableView->verticalHeader()->setAutoScroll(true);
    ui->tableView->setItemDelegate(new readonlyDelegate(this));//lock the data
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::addItem(QString path)
{
    if(iterateCheck(path)) return;
    QStringList splitList = path.split("/",QString::SkipEmptyParts);
    QString file = splitList.last();
    QStringList splitFile = file.split(".",QString::SkipEmptyParts);
    QString ext = splitFile.last();
    QString name = file.remove(ext);
    name = name.remove(name.length()-1,1);

    QList<QStandardItem *> list;
    list.append(new QStandardItem(name));
    list.append(new QStandardItem(ext));
    list.append(new QStandardItem(path));
    model.appendRow(list);
}

bool MainWindow::iterateCheck(QString path)
{
    for(int i=0;i<model.rowCount();i++)
    {
        if(model.item(i,2)->text() == path)
        {
            return true;
        }
    }
    return false;
}

void MainWindow::addItems(QString path)
{
    QDir dir(path);
    if(dir.exists())
    {
        qDebug() << path;
        dir.setFilter(QDir::Files|QDir::NoDotAndDotDot);
        QFileInfoList list = dir.entryInfoList();
        foreach(QFileInfo f , list)
        {
            if(!f.isDir())
                this->addItem(f.filePath());
        }
    }
}

void MainWindow::on_pushButton_Add_clicked()
{
    QString file = QFileDialog::getOpenFileName(this,tr("打开："),tr("/home/user/MyDocs"));
    if(!file.isEmpty())
    {
        addItem(file);
    }
}

void MainWindow::on_pushButton_Dir_clicked()
{
    dirWindow.showNormal();
    this->hide();
}

void MainWindow::getPath()
{
    this->show();
    this->addItems(dirWindow.path);
}

bool MainWindow::Rename(QString path, QString oldname,QString newname)
{
    QFile file(path);
    QString newpath = path.replace(oldname,newname);
    return file.rename(newpath);
}
void MainWindow::ReOperation()
{
    int count = model.rowCount();
    int seqnum = ui->spinBox->value();
    QString path,oldname,newname;
    int max = 10;
    while(max <= seqnum + count)
    {
        max *= 10;
    }
    for(int i=0;i<count;i++)
    {
        path = model.item(i,2)->text();
        oldname = model.item(i,0)->text();


        newname = ui->lineEdit->text() + GetSeq(seqnum,max);


        if(Rename(path,oldname,newname))
        {
            model.item(i,0)->setText(newname);
            model.item(i,2)->setText(path.replace(oldname,newname));
            seqnum ++ ;
        }
        else
        {
            QMessageBox::warning(this,"Warn!!","This file:"+newname+" is already exist! This process interrupt.");
            break;
        }
    }
}

QString MainWindow::GetSeq(int num, int max)
{
    QString seq = "";
    QString n = QString::number(num);
    num = num>1 ? num : 2;
    num = num%10!=0 ? num : num+1;
    double u = num;
    double m = max;
    int dec = ceil(log10(m))-ceil(log10(u));
    while(dec > 0)
    {
        seq.append("0");
        dec--;
    }
    seq.append(n);
    return seq;
}

void MainWindow::on_pushButton_Rename_clicked()
{
    if(model.rowCount() != 0)
    {
        int flag = QMessageBox::question(NULL, "Attention", "Pay attention! The operation is not able to rollback!", QMessageBox::Yes | QMessageBox::No, QMessageBox::Yes);
        if(flag == QMessageBox::Yes)
        {
            ReOperation();
        }
    }
}

void MainWindow::on_tableView_clicked(QModelIndex index)
{
    qDebug()<<index.row()<<index.column();
    qDebug()<<model.item(index.row(),index.column())->text();
}


void MainWindow::on_pushButton_Remove_clicked()
{
    model.removeRow(ui->tableView->currentIndex().row());
}

void MainWindow::on_pushButton_switcher_clicked()
{
    switchItem();
}

void MainWindow::switchItem()
{
    if(ui->tableView->currentIndex().row() <= 0) return;
    QString tmpName;
    QString tmpExt;
    QString tmpPath;
    tmpName = model.item(ui->tableView->currentIndex().row(),0)->text();
    tmpExt = model.item(ui->tableView->currentIndex().row(),1)->text();
    tmpPath = model.item(ui->tableView->currentIndex().row(),2)->text();
    model.item(ui->tableView->currentIndex().row(),0)->setText(model.item(ui->tableView->currentIndex().row()-1,0)->text());
    model.item(ui->tableView->currentIndex().row(),1)->setText(model.item(ui->tableView->currentIndex().row()-1,1)->text());
    model.item(ui->tableView->currentIndex().row(),2)->setText(model.item(ui->tableView->currentIndex().row()-1,2)->text());
    model.item(ui->tableView->currentIndex().row()-1,0)->setText(tmpName);
    model.item(ui->tableView->currentIndex().row()-1,1)->setText(tmpExt);
    model.item(ui->tableView->currentIndex().row()-1,2)->setText(tmpPath);
    ui->tableView->selectRow(ui->tableView->currentIndex().row()-1);
}

void MainWindow::switchItem_down()
{
    if(ui->tableView->currentIndex().row()+1 >= model.rowCount()) return;
    QString tmpName;
    QString tmpExt;
    QString tmpPath;
    tmpName = model.item(ui->tableView->currentIndex().row(),0)->text();
    tmpExt = model.item(ui->tableView->currentIndex().row(),1)->text();
    tmpPath = model.item(ui->tableView->currentIndex().row(),2)->text();
    model.item(ui->tableView->currentIndex().row(),0)->setText(model.item(ui->tableView->currentIndex().row()+1,0)->text());
    model.item(ui->tableView->currentIndex().row(),1)->setText(model.item(ui->tableView->currentIndex().row()+1,1)->text());
    model.item(ui->tableView->currentIndex().row(),2)->setText(model.item(ui->tableView->currentIndex().row()+1,2)->text());
    model.item(ui->tableView->currentIndex().row()+1,0)->setText(tmpName);
    model.item(ui->tableView->currentIndex().row()+1,1)->setText(tmpExt);
    model.item(ui->tableView->currentIndex().row()+1,2)->setText(tmpPath);
    ui->tableView->selectRow(ui->tableView->currentIndex().row()+1);
}

void MainWindow::on_pushButton_help_clicked()
{
    hForm.showFullScreen();
    this->hide();
}

//void MainWindow::on_pushButton_min_clicked()
//{
//    QDBusConnection connection = QDBusConnection::sessionBus();
 //   QDBusMessage message = QDBusMessage::createSignal("/","com.nokia.hildon_desktop","exit_app_view");
 //   connection.send(message);
//}

void MainWindow::on_pushButton_down_clicked()
{
    switchItem_down();
}
