// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef SKILLTREE_H
#define SKILLTREE_H

#include <QObject>
#include <QHash>

class QNetworkAccessManager;
class QNetworkReply;

class SkillTree : public QObject
{
    Q_OBJECT
public:
    explicit SkillTree(QObject *parent = 0);
    QString skillName(const int code) const { return skillNames.value(code); }
signals:
    void skillsLoaded();
public slots:
    void loadSkills();
    void replyReady();
    void save();
private:
    void fromXml(QByteArray &content);
    QHash<int,QString> skillNames;
    QNetworkAccessManager *mgr;
    QNetworkReply *reply;
};

#endif // SKILLTREE_H
