#include "evetrainingqueue.h"
#include <QSharedPointer>
#include <QtDebug>
#include "eveaccount.h"
#include "evemodel.h"
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QXmlStreamReader>

EveTrainingQueue::EveTrainingQueue(QObject *parent) :
    QObject(parent),
    m_reply(NULL)
{
}

void EveTrainingQueue::fetchInfo()
{
    if (m_character == NULL || m_account == NULL)
        return;
    if (cachedUntil.isValid()) {
        if (cachedUntil > QDateTime::currentDateTime().toUTC() ) {
            qDebug() << "Cached until " << cachedUntil.toString(Qt::SystemLocaleShortDate);
            return;
        }
    }
    QNetworkRequest req(QUrl(QString("http://api.eveonline.com/char/SkillQueue.xml.aspx?apiKey=%1&userID=%2&characterID=%3")
                             .arg(m_account->apiKey())
                             .arg(m_account->userId())
                             .arg(m_character->characterId)));
    m_reply = m_mgr.get(req);
    connect(m_reply,SIGNAL(finished()),this,SLOT(infoReady()));
}

void EveTrainingQueue::infoReady()
{
    if (m_reply->error()) {
        qDebug() << "Failed! " << m_reply->errorString();
        return;
    }
    qDebug() << "Skill queue reply";
    QByteArray reply = m_reply->readAll();
    qDebug() << "Reply ready";
    qDebug() << reply;
    QXmlStreamReader reader(reply);
    fromXml(reader);
    m_reply->deleteLater();
    emit finished();
}

void EveTrainingQueue::fromXml(QXmlStreamReader &input)
{

}
