// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef EVESKILLTRAINING_H
#define EVESKILLTRAINING_H

#include <QObject>
#include <QDateTime>
#include <QString>
#include <QXmlStreamReader>
#include <QNetworkAccessManager>
#include <QtDebug>

class EveCharacter;
class EveModel;

class TrainingEntry {
public:
    QDateTime startTime;
    QDateTime endTime;
    int typeId;
    int startSkillpoints;
    int destSkillpoints;
    int level;
};

QDebug operator<<(QDebug, const TrainingEntry &);

class EveSkillTraining : public QObject
{
    Q_OBJECT
public:
    explicit EveSkillTraining(QObject *parent = 0);
    bool fromXml(QXmlStreamReader &xml);
    void setCharacter(EveCharacter *character) { m_character = character; }
    void setAccount(EveModel *aModel) { m_account = aModel; }
    bool isTraining() { return !m_trainingQueue.isEmpty(); }
    const TrainingEntry &firstTraining() const { return m_trainingQueue.first(); }
    const TrainingEntry &lastTraining() const { return m_trainingQueue.last(); }
    bool isLoading() { return m_loading; }
signals:
    void finished();

public slots:
    void fetchInfo();
    void infoReady();
public:
    bool training;
    QDateTime cachedUntil;
    QDateTime currentTime;
private:
    EveCharacter *m_character;
    EveModel *m_account;
    QNetworkAccessManager m_mgr;
    QNetworkReply *m_reply;
    QList<TrainingEntry> m_trainingQueue;
    bool m_loading;
};



#endif // EVESKILLTRAINING_H
