// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef WIDGET_H
#define WIDGET_H

#include <QtGui/QLabel>

#include <QSharedPointer>
#include <QMouseEvent>
//QTM_USE_NAMESPACE

class EveCharacter;
class EveSettingsDialog;
class EveSkillTraining;
class SkillTree;
class EveModel;

class Widget : public QLabel
{
    Q_OBJECT
    enum TrainingState {
        QueueEmpty, // <! No items in training queue
        QueuePartial, // <! The queue still has room
        QueueFull // <! The queue is full
    };

public:
    Widget(QWidget *parent = 0);
    ~Widget();
    QSize sizeHint() const;

public slots:
    void showSettingsDialog();
    void paintEvent(QPaintEvent *event);
    void skillReady();
    void onlineStateChanged(bool online);
    void loadTraining();
    void trainingLoaded();
    virtual void mousePressEvent ( QMouseEvent * event );
    virtual void mouseReleaseEvent ( QMouseEvent * event );
private:
    EveSettingsDialog *m_settings;
    EveSkillTraining *m_training;
    //QNetworkConfigurationManager *m_net;
    SkillTree *m_skills;
    QSharedPointer<EveModel> m_model;
    QTimer *m_timer;
    QTimer *m_updateTimer;
    bool m_pressed;
};

#endif // WIDGET_H
