#ifndef EVETRAININGQUEUE_H
#define EVETRAININGQUEUE_H

#include <QObject>
#include <QSharedPointer>
#include <QtDebug>
#include "eveaccount.h"
#include "evemodel.h"
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QXmlStreamReader>

class EveTrainingQueue : public QObject
{
    Q_OBJECT
public:
    explicit EveTrainingQueue(QObject *parent = 0);
    void setCharacter(EveCharacter *aCharacter) { m_character = QSharedPointer<EveCharacter>(aCharacter); }
    void setAccount(EveModel *aModel) { m_character = QSharedPointer<EveModel>(aModel); }
signals:
    void finished();
public slots:
    void fetchInfo();
    void infoReady();
private:
    void fromXml(QXmlStreamReader &input);
    QSharedPointer<EveCharacter> m_character;
    QSharedPointer<EveModel> m_account;
    QNetworkAccessManager m_mgr;
    QNetworkReply *m_reply;
};

#endif // EVETRAININGQUEUE_H
