// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "skilltree.h"
#include <QFile>
#include <QDataStream>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QtDebug>
#include <QXmlStreamReader>
#include <assert.h>

SkillTree::SkillTree(QObject *parent) :
    QObject(parent),
    mgr(0),
    reply(0)
{
    QFile cacheFile("/var/tmp/skillCache");
    if (cacheFile.exists()) {
        QDataStream input(&cacheFile);
        input >> skillNames;
    } else {
        // load from network

    }

}

void SkillTree::loadSkills()
{
    QFile cacheFile("/var/tmp/skillCache");
    if (cacheFile.exists()) {
        cacheFile.open(QIODevice::ReadOnly);
        qDebug() << "Load from file";
        QDataStream input(&cacheFile);
        input >> skillNames;
        emit skillsLoaded();
    } else {
        // load from network
        qDebug() << "load skills from network";
        mgr = new QNetworkAccessManager(this);
        QNetworkRequest req(QUrl("http://api.eveonline.com//eve/SkillTree.xml.aspx"));
        reply = mgr->get(req);
        connect(reply,SIGNAL(finished()),this,SLOT(replyReady()));
    }
}

void SkillTree::replyReady()
{
    qDebug() << "Reply ready";
    if (!reply->error()) {
        QByteArray replyContent = reply->readAll();
        //qDebug() << replyContent;
        fromXml(replyContent);
        save();
        reply->deleteLater();
        emit skillsLoaded();
    } else {
        qDebug() << "fetch error:" << reply->errorString();
    }
}

void SkillTree::fromXml(QByteArray &content)
{
    QXmlStreamReader xml(content);
    xml.readNextStartElement(); //eveapi
    //assert(xml.name() == "eveapi");
    xml.readNextStartElement(); //currentTime
    xml.skipCurrentElement();
    //assert(xml.name() == "currentTime");
    xml.readNextStartElement(); //result
    xml.readNextStartElement(); // rowset for skill groups
    bool groupsLeft = xml.readNextStartElement(); // row for skill group
    while (groupsLeft) {
        xml.readNextStartElement(); // rowset for skills
        bool skillsLeft = xml.readNextStartElement(); // row for skill
        while (skillsLeft) {
            assert(xml.name() == "row");
            QString name = xml.attributes().value("","typeName").toString();
            int typeId = xml.attributes().value("","typeID").toString().toInt();
            //qDebug() << "Found skill " << name << ":" << typeId;
            skillNames[typeId] = name;

            xml.skipCurrentElement(); // description
            skillsLeft = xml.readNextStartElement(); // next skill row
        }
        xml.readNextStartElement(); // rowset ends
        groupsLeft = xml.readNextStartElement(); // next skill group row
    }
    int len = 0;
    QString name;
    QString longestName;
    foreach (name,skillNames) {
        if (name.length() > len) {
            longestName = name;
            len = name.length();
        }
    }

    //qDebug() << skillNames;
    qDebug() << longestName;
}

void SkillTree::save()
{
    QFile cache("/var/tmp/skillCache");
    cache.open(QIODevice::WriteOnly);
    QDataStream output(&cache);
    output << skillNames;
    cache.flush();
    cache.close();
}

