// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "evesettingsdialog.h"
#include "ui_evesettingsdialog.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QtDebug>
#include <QtMaemo5>
#include <QtGui>
#include <QSettings>

EveSettingsDialog::EveSettingsDialog(QWidget *parent) :
    QDialog(parent),
    m_reply(0),
    m_selection(0),
    userIdEdit(new QLineEdit(this)),
    apiKeyEdit(new QLineEdit(this)),
    characterPicker(new QMaemo5ValueButton(this)),
    characterSelector(new QMaemo5ListPickSelector),
    characterModel(new QStandardItemModel(0,1,this)),
    m_layout(new QVBoxLayout(this))
{
    setWindowTitle("EVE account");
    //QHBoxLayout *hbox = new QHBoxLayout(this);
    //QDialogButtonBox *buttons = new QDialogButtonBox(QDialogButtonBox::Ok|QDialogButtonBox::Cancel,Qt::Vertical,this);
    //hbox->addLayout(m_layout);
    //hbox->addWidget(buttons);
    setLayout(m_layout);
    QLabel *label1 = new QLabel("User ID");
    m_layout->addWidget(label1);
    m_layout->addWidget(userIdEdit);
    QLabel *label2 = new QLabel("API key");
    m_layout->addWidget(label2);
    m_layout->addWidget(apiKeyEdit);
    m_layout->addWidget(characterPicker);
    characterSelector->setModel(characterModel);
    characterSelector->setModelColumn(0);
    characterPicker->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    characterPicker->setText("Character");

    QPushButton *button = new QPushButton("Done");
    m_layout->addWidget(button);
    characterPicker->setPickSelector(characterSelector);
    connect(button,SIGNAL(pressed()),this,SLOT(donePressed()));
    //connect(buttons,SIGNAL(rejected()),this,SLOT(reject()));
    //connect(ui->getCharactersButton,SIGNAL(pressed()),this,SLOT(tryLoadCharacters()));
    //connect(ui->characterCombo,SIGNAL(currentIndexChanged(int)),this,SLOT(characterSelected(int)));
    //connect(apiKeyEdit,SIGNAL(editingFinished()),this,SLOT(tryLoadCharacters()));
    //connect(userIdEdit,SIGNAL(editingFinished()),this,SLOT(tryLoadCharacters()));
    //connect(characterSelector->view(),SIGNAL(activated(const QModelIndex &)),this,SLOT(characterSelected()));
    connect(characterPicker,SIGNAL(pressed()),this,SLOT(tryLoadCharacters()));
    //connect(characterSelector,SIGNAL(selected(const QString &)),characterPicker,SLOT(setValuetext(const QString &)));
}



void EveSettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        //retranslateUi(this);
        break;
    default:
        break;
    }
}

void EveSettingsDialog::tryLoadCharacters()
{
    if (!apiKeyEdit->text().isEmpty() &&
        !userIdEdit->text().isEmpty()) {
        qDebug() << "Load characters, API key " << apiKeyEdit->text() << " user ID: " << userIdEdit->text();
        characterModel->clear();
        QStandardItem *item = new QStandardItem("Retrieving characters, please wait...");

        characterModel->appendRow(item);
        if (m_model.isNull()) {
            m_model = QSharedPointer<EveModel>(new EveModel);
        }
        m_model->setApiKey(apiKeyEdit->text());
        m_model->setUserId(userIdEdit->text().toInt());
        connect(m_model.data(),SIGNAL(accountsReady()),this,SLOT(charactersLoaded()));
        m_model->fetchAccounts();
        setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    }
}

// Setting the model also sets the
// API key and user info since
// Widget is responsible for loading and saving

void EveSettingsDialog::setModel(QSharedPointer<EveModel> &model)
{
    qDebug() << "Set model";
    m_model = model;
    apiKeyEdit->setText(m_model->apiKey());
    if (m_model->userId() != 0)
        userIdEdit->setText(QString::number(m_model->userId()));

    charactersLoaded();
    characterSelector->setCurrentIndex(m_model->selectedIndex());
}

void EveSettingsDialog::charactersLoaded()
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
    EveCharacter c;
    qDebug() << "Characters loaded";
    characterModel->clear();
    foreach (c,m_model->characters()) {
        qDebug() << "Found " << c.name;
        QStandardItem *item = new QStandardItem(c.name);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        characterModel->appendRow(item);
    }
}

int EveSettingsDialog::selectedCharacter()
{
    return characterSelector->currentIndex();
}

void EveSettingsDialog::characterSelected()
{

}

void EveSettingsDialog::donePressed()
{
    m_model->saveSettings();
    accept();
}
