// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "eveaccount.h"
#include "QXmlStreamReader"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QtDebug>

EveCharacter::EveCharacter(QObject *parent) :
    QObject(parent),
    characterId(0),
    corpId(0),
    characterIcon(NULL)
{
}

EveCharacter::EveCharacter(const EveCharacter &aOther):
        QObject(aOther.parent()),
        name(aOther.name),
        corpName(aOther.corpName),
        characterId(aOther.characterId),
        corpId(aOther.corpId),
        characterIcon(NULL)
{
    if (aOther.characterIcon) {
        characterIcon = new QPixmap(*(aOther.characterIcon));
    }
}

EveCharacter::~EveCharacter()
{
    if (characterIcon)
        delete characterIcon;
    characterIcon = NULL;
}

EveCharacter &EveCharacter::operator =(const EveCharacter &other)
{
    name = other.name;
    characterId = other.characterId;
    corpId = other.corpId;
    corpName = other.corpName;
    qDebug() << "Assignment, characterIcon " << characterIcon;
    if (characterIcon != NULL) {
        delete characterIcon;
        characterIcon = NULL;
    }
    qDebug() << " after deletion";
    qDebug() << " other icon" << other.characterIcon;
    if (other.characterIcon != NULL)
        characterIcon = new QPixmap(*(other.characterIcon));
    qDebug() << "Assignment done";
    return *this;
}

bool EveCharacter::fromXml(QXmlStreamReader &xml)
{
    if (xml.name() != "row")
        return false;
    name = xml.attributes().value("","name").toString();
    characterId = xml.attributes().value("","characterID").toString().toInt();
    corpName = xml.attributes().value("","corporationName").toString();
    corpId = xml.attributes().value("","corporationID").toString().toInt();
    return true;
}

bool EveCharacter::fetchImage()
{
    if (characterId == 0) {
        qDebug() << "No character";
        return false;
    }
    if (characterIcon != NULL) {
        return true;

    }
    qDebug() << "Requesting image";
    QNetworkRequest req(QUrl(QString("http://img.eve.is/serv.asp?c=%1&s=64").arg(characterId)));
    m_reply = mgr.get(req);
    connect(m_reply,SIGNAL(finished()),this,SLOT(imageReady()));
    return true;
}

// Construct the pixmap from the reply data
// and delete the reply
void EveCharacter::imageReady()
{
    qDebug() << "Image ready";
    characterIcon = new QPixmap;
    if (!characterIcon->loadFromData(m_reply->readAll())) {
        delete characterIcon;
        characterIcon = NULL;
        qDebug() << "Cannot load image";
        return;
    }
    m_reply->deleteLater();
    emit imageLoaded();
}
