// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef EVESKILLTRAINING_H
#define EVESKILLTRAINING_H

#include <QObject>
#include <QDateTime>
#include <QString>
#include <QXmlStreamReader>
#include <QNetworkAccessManager>

class EveCharacter;
class EveModel;

class EveSkillTraining : public QObject
{
    Q_OBJECT
public:
    explicit EveSkillTraining(QObject *parent = 0);
    bool fromXml(QXmlStreamReader &xml);
    void setCharacter(EveCharacter *character) { m_character = character; }
    void setAccount(EveModel *aModel) { m_account = aModel; }
signals:
    void finished();

public slots:
    void fetchInfo();
    void infoReady();

public:
    bool training;
    QDateTime startTime;
    QDateTime endTime;
    QDateTime currentTime;
    int typeId;
    int startSkillpoints;
    int destSkillpoints;
    int level;
    QDateTime cachedUntil;
private:
    EveCharacter *m_character;
    EveModel *m_account;
    QNetworkAccessManager m_mgr;
    QNetworkReply *m_reply;

};

#endif // EVESKILLTRAINING_H
