// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "eveskilltraining.h"
#include "evemodel.h"
#include "eveaccount.h"

#include <QXmlStreamReader>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QtDebug>
EveSkillTraining::EveSkillTraining(QObject *parent) :
    QObject(parent),
    training(false),
    typeId(0),
    startSkillpoints(0),
    destSkillpoints(0),
    level(0),
    m_character(NULL),
    m_account(NULL),
    m_reply(NULL)
{
}

bool EveSkillTraining::fromXml(QXmlStreamReader &xml)
{
    xml.readNextStartElement();
    if (xml.name() != "eveapi")
        return false;
    xml.readNextStartElement();
    if (xml.name() != "currentTime")
        return false;

    xml.readNextStartElement(); // end currentTime element
    bool inResult = xml.readNextStartElement(); // start result element
    if (xml.name() != "result") {
        qDebug() << "Wrong element:" << xml.name();
        return false;
    }
    inResult = xml.readNextStartElement();
    while (inResult) {
        qDebug() << "element:" << xml.name();
        if (xml.name() == "trainingEndTime") {
            qDebug() << "Parse end time";
            endTime = QDateTime::fromString(xml.readElementText(),"yyyy-MM-dd hh:mm:ss");//2008-08-17 06:43:00
            startTime.setTimeSpec(Qt::UTC);
            qDebug()<< endTime;

        } else if (xml.name() == "trainingStartTime") {
            qDebug() << "Parse start time";
            startTime = QDateTime::fromString(xml.readElementText(),"yyyy-MM-dd hh:mm:ss");//2008-08-17 06:43:00
            startTime.setTimeSpec(Qt::UTC);
            qDebug() << startTime;

        } else if (xml.name() == "trainingTypeID") {
            typeId = xml.readElementText().toInt();

        } else if (xml.name() == "trainingStartSP"){
            startSkillpoints = xml.readElementText().toInt();

        } else if (xml.name() == "trainingDestinationSP"){
            destSkillpoints = xml.readElementText().toInt();

        } else if (xml.name() == "trainingToLevel"){
            level = xml.readElementText().toInt();
        } else if (xml.name() == "skillInTraining" ) {

            training = xml.readElementText().toInt() == 1;
            qDebug() << "Training?" << training;
        } else if (xml.name() == "currentTQTime" ) {
            currentTime = QDateTime::fromString(xml.readElementText(),"yyyy-MM-dd hh:mm:ss");
            startTime.setTimeSpec(Qt::UTC);
            qDebug() << "Current: " << currentTime;
        }  else {
            // Noop
            qDebug() << "  Skip this";
            xml.skipCurrentElement();
        }
        inResult = xml.readNextStartElement();

    } // while
    inResult = xml.readNextStartElement();
    if (xml.name() == "cachedUntil" ) {
        cachedUntil = QDateTime::fromString(xml.readElementText(),"yyyy-MM-dd hh:mm:ss");
        cachedUntil.setTimeSpec(Qt::UTC);
        qDebug() << "Cached until " << cachedUntil.toString(Qt::SystemLocaleShortDate);
    }
    qDebug() << "Parsing finished";
    return true;
}

void EveSkillTraining::fetchInfo()
{
    if (m_character == NULL || m_account == NULL)
        return;
    if (cachedUntil.isValid()) {
        if (cachedUntil > QDateTime::currentDateTime().toUTC() ) {
            qDebug() << "Cached until " << cachedUntil.toString(Qt::SystemLocaleShortDate);
            return;
        }
    }
    QNetworkRequest req(QUrl(QString("http://api.eveonline.com/char/SkillInTraining.xml.aspx?apiKey=%1&userID=%2&characterID=%3")
                             .arg(m_account->apiKey())
                             .arg(m_account->userId())
                             .arg(m_character->characterId)));
    m_reply = m_mgr.get(req);
    connect(m_reply,SIGNAL(finished()),this,SLOT(infoReady()));
}

void EveSkillTraining::infoReady()
{
    if (m_reply->error()) {
        qDebug() << "Failed! " << m_reply->errorString();
        return;
    }
    qDebug() << "Skill reply";
    QByteArray reply = m_reply->readAll();
    qDebug() << "Reply ready";
    qDebug() << reply;
    QXmlStreamReader reader(reply);
    fromXml(reader);
    m_reply->deleteLater();
    emit finished();
}
