/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
 */
 /**
  * @file estardict-gui.c
  * @author Luca Vaudano
  */
#include "estardict-gui.h"
#include "estardict-gui-logic.h"
#include "estardict-config.h"
#include "../include/config.h"
#include "i18n.h"


/**
 * @brief Create main window
 *
 * @return Main window
 */
Evas_Object* createMainWindow() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *bg;

    // Scale and finger size
    elm_config_finger_size_set( getFingerSize() );
    elm_config_scale_set( getScale() );

    // Basic window - name, title
    win = elm_win_add(NULL, "main", ELM_WIN_BASIC);
    elm_win_title_set(win, PACKAGE_NAME);

    // Standard background
    bg = elm_bg_add(win);
    evas_object_size_hint_weight_set(bg, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(win, bg);
    evas_object_show(bg);

    // Promote definition box
    promoteDefinitionPage();

    // Window size (size for pc application, for neo means full screen)
    evas_object_resize(win, SCREEN_WIDTH, SCREEN_HEIGHT);
    return win;
}





