#ifndef _ESTARDICT_GUI_UTILS_H
#define _ESTARDICT_GUI_UTILS_H
/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
*    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License along
*    with this program; if not, write to the Free Software Foundation, Inc.,
*    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
*/
 /**
  * @file estardict-gui-utils.h
  * @author Luca Vaudano
  */
/*********
 * HEADERS
 *********/
// GLIB
#include <glib.h>
#include "estardict-gui.h"
#include "i18n.h"

// Enlightenment Elementary
#include <Elementary.h>

/******
 * DEFINITIONS
 ******/

/**** **
 * DATA STRUCTURES
 *******/

/****
 * METHODS
 ******/
char *init_locale (void);
void showFileSelector(void *data, Evas_Object *obj, void *event_info, gboolean folderOnly);
gchar* getNameFromPath(const gchar* path);
gchar* trimwhitespace(gchar *str);
gchar* formatDefinition(gchar *definition);
void createDialog(Evas_Object *win, gchar* text);
gchar* truncateWord(gchar* word);
gboolean checkFileExists(const char * filename);
gchar* addSpaces(gchar* text);
void setLogLevel(int argc, char **argv);

#endif
