#include "minunit.h"
#include "../engine/estardict-engine.h"

#undef G_LOG_DOMAIN
#define G_LOG_DOMAIN "estardict-engine-tests"

#define WORD "dog"
#define LONGMAN "stardict-longman-2.4.2"
#define BABYLON_EN_IT "stardict-babylon-Babylon_English_Italian-2.4.2"
#define ENGLISH_CZECH "stardict-english-czech"

#define LONGMAN_DEFINITION_DOG_LENGHT 3184
#define BABYLON_EN_IT_DEFINITION_DOG_LENGHT 95
#define ENGLISH_CZECH_DEFINITION_DOG_LENGHT 191

gchar * path;
int tests_run = 0;

static char* testDict(gchar *relativeDictPath) {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);

    gchar *result = NULL;
    gchar* definition = NULL;
    gchar* absDictPath = NULL;
    StarDictInfo* starDictInfo = NULL;
    
    if ( path != NULL ) {

        absDictPath = g_strconcat(path, "/", relativeDictPath, NULL);
        starDictInfo = loadDictionary(absDictPath);

        if (starDictInfo != NULL) {
            definition = getDefinition(starDictInfo, WORD);
            g_message("\t Dictionary %s", relativeDictPath);
            g_message("\t type %s", starDictInfo->sametypesequence);
            g_debug("definition for %s:\n%s", WORD, definition);
            g_debug("lenght definition for %s:\n%d", WORD, strlen(definition));

            // LONGMAN
            if (
                strcmp(relativeDictPath, LONGMAN) == 0 &&
                strlen(definition) == LONGMAN_DEFINITION_DOG_LENGHT
            ) {
                g_message("\t OK");
            }

            // BABYLON_EN_IT
            else if (
                strcmp(relativeDictPath, BABYLON_EN_IT) == 0 &&
                strlen(definition) == BABYLON_EN_IT_DEFINITION_DOG_LENGHT
            ) {
                g_message("\t OK");
            }

            // ENGLISH_CZECH
            else if (
                strcmp(relativeDictPath, ENGLISH_CZECH) == 0 &&
                strlen(definition) == ENGLISH_CZECH_DEFINITION_DOG_LENGHT
            ) {
                g_message("\t OK");
            }

            // ERROR
            else {
                g_message("\t FAILED");
                result = g_strdup("ERROR");
            }

        } else {
            g_message("\t FAILED");
            result = g_strdup("ERROR");
        }

        freeData(starDictInfo);
        
    } else {
        g_message("\t FAILED - Path not defined");
        result = g_strdup("ERROR");
    }
    return result;
}

static char* testTwoDicts() {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);

    gchar *result = NULL;

    gchar* definition1 = NULL;
    gchar* absDictPath1 = NULL;
    StarDictInfo* starDictInfo1 = NULL;

    gchar* definition2 = NULL;
    gchar* absDictPath2 = NULL;
    StarDictInfo* starDictInfo2 = NULL;

    absDictPath1 = g_strconcat(path, "/", LONGMAN, NULL);
    absDictPath2 = g_strconcat(path, "/", BABYLON_EN_IT, NULL);

    starDictInfo1 = loadDictionary(absDictPath1);
    starDictInfo2 = loadDictionary(absDictPath2);

    if ( starDictInfo1 != NULL && starDictInfo2 != NULL ) {

        definition1 = getDefinition(starDictInfo1, WORD);
        definition2 = getDefinition(starDictInfo2, WORD);

        g_message("\t Two dictionaries");
        g_message("\t %s and %s", LONGMAN, BABYLON_EN_IT);

        g_debug("definition1 for %s:\n%s", WORD, definition1);
        g_debug("definition2 for %s:\n%s", WORD, definition2);

        // LONGMAN
        if (
            ( strlen(definition1) + strlen(definition2) ) == ( LONGMAN_DEFINITION_DOG_LENGHT + BABYLON_EN_IT_DEFINITION_DOG_LENGHT )
        ) {
            g_message("\t OK");
        }

        // ERROR
        else {
            g_message("\t FAILED");
            result = g_strdup("ERROR");
        }

    } else {
        g_message("\t FAILED");
        result = g_strdup("ERROR");
    }

    freeData(starDictInfo1);
    freeData(starDictInfo2);

    return result;
}

static char* testLongman() {
    return testDict(LONGMAN);
}

static char* testBabylonEnIt() {
    return testDict(BABYLON_EN_IT);
}

static char* testEnglishCzech() {
    return testDict(ENGLISH_CZECH);
}

static char* testLongmanBabylonDicts() {
    return testTwoDicts();
}

/*
static char* failed() {
    return "1";
}
*/

static char * all_tests() {
    //g_message("TEST1");
    //mu_run_test(testLongman);
    //g_message("TEST2");
    //mu_run_test(testBabylonEnIt);
    //g_message("TEST3");
    //mu_run_test(testLongmanBabylonDicts);
    //g_message("TEST4");
    //mu_run_test(testEnglishCzech);
    //g_message("TEST5");
    //mu_run_test(testDiacritics);
    //g_message("TEST");
    //mu_run_test(failed);
    return 0;
}

void logMessage(const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data) {

    // Enable message
    if ( log_domain != NULL && strcmp(log_domain, G_LOG_DOMAIN) == 0 && log_level == G_LOG_LEVEL_MESSAGE ) {
        printf("%s\n", message);
    }

    // Enable debug message
    if ( log_domain != NULL && strcmp(log_domain, G_LOG_DOMAIN) == 0 && log_level == G_LOG_LEVEL_DEBUG ) {
        printf("%s\n", message);
    }
}

void disableMessage(const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data) {
}

int main(int argc, char **argv) {

    if ( argc != 2 ) {
        printf("estardict-engine-tests <path with dictionaries>\n");
        printf("\t where\n");
        printf("<path with dictionaries> contains %s and %s folders\n", LONGMAN, BABYLON_EN_IT);
        return 0;
    }
    path = argv[1];

    g_log_set_handler(G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE | G_LOG_LEVEL_DEBUG, logMessage, NULL);
    g_log_set_handler(NULL, G_LOG_LEVEL_MESSAGE | G_LOG_LEVEL_DEBUG, disableMessage, NULL);

    g_debug("%s", path);

    char *result = all_tests();
    if (result != 0) {
        g_message("%s", result);
    } else {
        g_message("ALL TESTS PASSED");
    }
    g_message("Tests run: %d", tests_run);

    return result != 0;
}
