#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QPainter>
#include <QImage>
#include <QPaintEvent>
#include <QShowEvent>
#include <QDateTime>
#include <QTimer>
#include <QDesktopWidget>
#include <QSettings>
#include <QString>
#include <QPalette>
#include <QDebug>
#include <backends/systemplayer.h>
#ifdef Q_WS_MAEMO_5
    #include <QDBusInterface>
    #include <mce/dbus-names.h>
    #include <mce/mode-names.h>
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void paintEvent(QPaintEvent *);
    void showEvent(QShowEvent *);

private:
    Ui::MainWindow *ui;
    QString m_tklockState;
    QString m_imageUrl;
    bool m_isCallActive;
    SystemPlayer *m_player;
    SystemPlayer::PlaybackState m_state;
    void connectSignals();

private slots:
    void unlock();
    void setHildonFlags();
    void onTkLockChanged(QString);
    void connectMCESignals();
    void updateTime();
    void onStateChanged(SystemPlayer::PlaybackState);
    void onPlayButtonClicked();
    void onMetadataChanged(QMap<QString,QVariant>);
    void onCallStateChanged(QString state);
    void sliderValueChanged(int value);
    void prevButtonPressed();
    void nextButtonPressed();
    void playButtonPressed();
    void orientationChanged();
};

#endif // MAINWINDOW_H
