#include "systemplayer.h"

SystemPlayer::SystemPlayer(QObject *parent) :
    QObject(parent)
{
#ifdef Q_WS_MAEMO_5
    m_renderer = new MafwRendererAdapter(this);
    connect(m_renderer, SIGNAL(stateChanged(int)), this, SLOT(mafwStateChanged(int)));
    connect(m_renderer, SIGNAL(signalGetStatus(MafwPlaylist*,uint,MafwPlayState,const char*,QString)),
            this, SLOT(onGotMafwState(MafwPlaylist*,uint,MafwPlayState,const char*,QString)));
    connect(m_renderer, SIGNAL(signalGetCurrentMetadata(GHashTable*,QString,QString)),
            this, SLOT(onGotMafwMetadata(GHashTable*,QString,QString)));
    connect(m_renderer, SIGNAL(metadataChanged(QString,QVariant)), m_renderer, SLOT(getCurrentMetadata()));
    if (m_renderer->isRendererReady()) {
        m_renderer->getStatus();
        m_renderer->getCurrentMetadata();
    } else {
        connect(m_renderer, SIGNAL(rendererReady()), m_renderer, SLOT(getStatus()));
        connect(m_renderer, SIGNAL(rendererReady()), m_renderer, SLOT(getCurrentMetadata()));
    }
#endif
}

void SystemPlayer::play()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->play();
#endif
}

void SystemPlayer::resume()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->resume();
#endif
}

void SystemPlayer::pause()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->pause();
#endif
}

void SystemPlayer::stop()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->stop();
#endif
}

void SystemPlayer::next()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->next();
#endif
}

void SystemPlayer::previous()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->previous();
#endif
}


SystemPlayer::PlaybackState SystemPlayer::state()
{
    return m_state;
}

#ifdef Q_WS_MAEMO_5
void SystemPlayer::mafwStateChanged(int mafwState)
{
    if (m_mafwState == mafwState)
        return;

    m_mafwState = mafwState;

    SystemPlayer::PlaybackState oldState = m_state;
    switch (mafwState) {
    case Playing:
        m_state = SystemPlayer::PlayingState;
        break;
    case Paused:
        m_state = SystemPlayer::PausedState;
        break;
    case Stopped:
        m_state = SystemPlayer::StoppedState;
        break;
    case Transitioning:
        break;
    case _LastMafwPlayState:
        break;
    }

    if (oldState != m_state)
        emit stateChanged(m_state);
}

void SystemPlayer::onGotMafwState(MafwPlaylist*, uint, MafwPlayState state, const char*, QString)
{
    this->mafwStateChanged(state);
}

void SystemPlayer::onGotMafwMetadata(GHashTable* table,QString,QString)
{
    QMap <QString, QVariant> metadata;
    GValue *v;
    v = mafw_metadata_first(table, MAFW_METADATA_KEY_ARTIST);
    QString artist = v ? QString::fromUtf8(g_value_get_string(v)) : "(unknown artist)";

    v = mafw_metadata_first(table, MAFW_METADATA_KEY_TITLE);
    QString songName = v ? QString::fromUtf8(g_value_get_string(v)) : "(unknown song)";

    v = mafw_metadata_first(table, MAFW_METADATA_KEY_ALBUM);
    QString album = v ? QString::fromUtf8(g_value_get_string(v)) : "(unknown album)";

    metadata.insert(SYSTEM_PLAYER_SONG_TITLE, songName);
    metadata.insert(SYSTEM_PLAYER_SONG_ALBUM, album);
    metadata.insert(SYSTEM_PLAYER_SONG_ARTIST, artist);

    emit metadataChanged(metadata);
}
#endif
