/*
  EightyOne - A simple Sudoku solving game
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "GenerateDialog.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/Def/OneOfMany.h>

#include <Lum/OS/Theme.h>

#include <Lum/Label.h>
#include <Lum/Panel.h>

GenerateDialog::Level::Level(const std::wstring& label,
                             size_t points)
 : label(label),
   points(points)
{
  // no code
}

GenerateDialog::GenerateDialog(size_t points)
 : commitAction(new Lum::Model::Action()),
   level(new Lum::Model::SizeT(3)),
   success(false)
{
  levels.push_back(Level(_(L"POINTS_LEVEL_VERY_EASY",L"Very Easy"),1000));
  levels.push_back(Level(_(L"POINTS_LEVEL_EASY",L"Easy"),2500));
  levels.push_back(Level(_(L"POINTS_LEVEL_NORMAL",L"Normal"),4000));
  levels.push_back(Level(_(L"POINTS_LEVEL_DIFFICULT",L"Difficult"),8000));
  levels.push_back(Level(_(L"POINTS_LEVEL_HARD",L"Hard"),15000));
  levels.push_back(Level(_(L"POINTS_LEVEL_IMPOSSIBLE",L"Impossible"),25000));

  Observe(GetClosedAction());

  Observe(commitAction);
  Observe(level);
}

Lum::Object* GenerateDialog::GetContent()
{
  Lum::Label                 *label;
  Lum::Model::StringTableRef levelsModel;

  label=Lum::Label::Create(true,false);

  levelsModel=new Lum::Model::StringTable();

  for (std::list<Level>::const_iterator l=levels.begin();
       l!=levels.end();
       ++l) {
    levelsModel->Append(l->label);
  }

  Lum::Def::OneOfMany levelDef(Lum::Def::Desc(L"Levels"),
                               level,
                               levelsModel);

  label->AddLabel(_(L"POINTS_MIN",L"Min. Points:"),
                  Lum::OS::display->GetBehaviour()->GetOneOfManyControl(levelDef,true,false));

  return label;
}

void GenerateDialog::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  actions.push_back(Lum::Dlg::ActionInfo(Lum::Dlg::ActionInfo::typeCommit,
                                         _(L"GENERATE",L"_Generate"),
                                         Lum::OS::display->GetTheme()->GetStockImage(Lum::OS::Theme::imagePositive),
                                         commitAction,
                                         true));

  CreateActionInfosCancel(actions,GetClosedAction());
}

void GenerateDialog::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==commitAction &&
      commitAction->IsFinished()) {
    success=true;
    Exit();
  }
  else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Dialog::Resync(model,msg);
}

bool GenerateDialog::GetSuccess() const
{
  return success;
}

size_t GenerateDialog::GetPoints() const
{
  std::list<Level>::const_iterator l=levels.begin();

  if (level->Get()>1) {
    std::advance(l,level->Get()-1);
  }

  return l->points;
}

bool ShowGenerateDialog(Lum::Dialog* parent, size_t& points)
{
  GenerateDialog *dialog;
  bool            success;

  dialog=new GenerateDialog(points);
  dialog->SetParent(parent);

  if (dialog->Open()) {
    dialog->EventLoop();
    dialog->Close();
  }

  success=dialog->GetSuccess();
  if (success) {
    points=dialog->GetPoints();
  }

  delete dialog;

  return success;
}

