#ifndef GAMEAREA_H
#define GAMEAREA_H

/*
  EightyOne - A simple Sudoku solving game
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Boolean.h>

#include "GameModel.h"


class GameArea : public Lum::Control
{
private:
  Lum::OS::FontRef       minFont;
  Lum::OS::FontRef       minMarkFont;
  Lum::OS::FontRef       font;
  Lum::OS::FontRef       markFont;
  Lum::OS::ColorRef      presetColor;
  Lum::OS::ColorRef      focusBackgroundColor;
  Lum::OS::ColorRef      errorColor;
  Lum::OS::ColorRef      correctColor;
  Lum::OS::ColorRef      hintColor;
  size_t                 boxSize;
  size_t                 size;

  Lum::Model::BooleanRef hintMode;

  GameModelRef           model;

private:
  int GetCellOffset(size_t index) const;

public:
  GameArea();

  bool HandlesClickFocus() const;
  bool HandlesKeyFocus() const;

  bool SetModel(Lum::Base::Model* model);

  void CalcSize();
  void Layout();

  Lum::OS::Font* FindFont(Lum::OS::Font* minFont,
                          size_t size);

  void Draw(Lum::OS::DrawInfo* draw,
            int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);
  bool HandleKeyEvent(const Lum::OS::KeyEvent& event);

  Lum::Model::Boolean* GetHintMode() const;

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
