/*
  EightyxOne - A simple Sudoku solving game
  Copyright (C) 2006  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Configuration.h"

#include <assert.h>
#include <stdlib.h>
#include <dirent.h>

#include <iostream>
#include <fstream>

#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Config/Config.h>

Game*  game=NULL;
size_t targetLevelPoints=4000;

bool LoadConfig()
{
  Lum::Config::Node      *top;
  Lum::Config::Node      *node;
  Lum::Config::ErrorList errors;
  Lum::Base::Path        path(Lum::Base::Path::GetApplicationConfigPath());

  top=Lum::Config::LoadConfigFromXMLFile(path.GetPath(),errors);

  if (top==NULL) {
    return false;
  }

  if (top->GetName()!=L"EightyOne") {
    std::cerr << "'" << Lum::Base::WStringToString(path.GetPath()) << "' is a valid config file!" << std::endl;
    delete top;
    return false;
  }

  node=top->GetChild(L"targetLevelPoints");
  if (node!=NULL) {
    node->GetValue(targetLevelPoints);
  }

  node=top->GetChild(L"currentGame");
  if (node!=NULL) {
    std::wstring riddle,solution,game,marks;

    if (node->GetAttribute(L"riddle",riddle) &&
        node->GetAttribute(L"solution",solution) &&
        node->GetAttribute(L"game",game)) {
      ::game=new Game();
      ::game->riddle=riddle;
      ::game->solution=solution;
      ::game->game=game;
      ::game->marks=L"";
    }

    if (node->GetAttribute(L"marks",marks)) {
      ::game->marks=marks;
    }
  }

  delete top;

  return true;
}

bool SaveConfig()
{
  Lum::Config::Node *top;
  Lum::Config::Node *node;
  Lum::Base::Path   path(Lum::Base::Path::GetApplicationConfigPath());
  bool              res;

  top=new Lum::Config::Node(L"EightyOne");

  if (game!=NULL) {
    node=new Lum::Config::Node(L"targetLevelPoints");
    node->SetValue(targetLevelPoints);
    top->Add(node);

    node=new Lum::Config::Node(L"currentGame");
    node->SetAttribute(L"riddle",game->riddle);
    node->SetAttribute(L"solution",game->solution);
    node->SetAttribute(L"game",game->game);
    node->SetAttribute(L"marks",game->marks);
    top->Add(node);
  }

  Lum::Base::Status status;

  status=path.CreateDirRecursive();

  if (!status) {
    std::cerr << "Cannot create config directory '" << Lum::Base::WStringToString(path.GetDir()) << "': " << Lum::Base::WStringToString(status.GetDescription()) << std::endl;
    return false;
  }

  res=Lum::Config::SaveConfigToXMLFile(path.GetPath(),top);

  delete top;

  return res;
}

void FreeConfig()
{
  delete game;
}
