#ifndef UIHELPER_H
#define UIHELPER_H

#include <QObject>
#include <QGraphicsObject>
#include <QRect>
#include <QtDeclarative/QDeclarativeView>
#include "facebookgraph/place.h"
#include "placeslistmodel.h"


class UiHelper : public QObject
{
    Q_OBJECT
public:
    explicit UiHelper(QObject *parent = 0);
    void setGeometry(const QRect rect);
    void show();
    void showMaximized();

signals:
    void refreshClicked();
    void configClicked();
    void facebookClicked();
    void needLocation();
    void dontNeedLocation();

    void submitClicked(QString status);
    void submitCheckinClicked(QString status, QString placeId, qreal latitude, qreal longitude);
    void needPlaces(qreal latitude, qreal longitude);

    //Signals for passing along to QML slots
    void setOldStatusSignal(QVariant status);
    void clearStatusBoxSignal();
    void setGpsStatusSignal(QVariant status);
    void setLocationSignal(QVariant latitude, QVariant longitude);


public slots:
    void setOldStatus(QString status);
    void clearStatusBox();
    void setGpsStatus(int status);
    void setLocation(qreal latitude, qreal longitude);
    void setPlacesNearby(QList<Place*> places);

private slots:
    void submitCheckinClickedSlot(QString status, QString placeId, qreal latitude, qreal longitude);

private:
    QDeclarativeView view;
    PlacesListModel placesListModel;

};

#endif // UIHELPER_H
