#include "uihelper.h"
#include <QDebug>
#include <QDeclarativeContext>
#include <QDeclarativeItem>

UiHelper::UiHelper(QObject *parent) :
    QObject(parent)
{
    //Load up our list model
    view.rootContext()->setContextProperty("qtPlacesListModel",&placesListModel);

    //Create our QML object
    view.setSource(QUrl("qrc:/eff.qml"));
    view.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view.setWindowTitle("Effing Status Updater");
    QObject *qmlObject = dynamic_cast<QObject*>(view.rootObject());

    //Simple signals
    QObject::connect(qmlObject,SIGNAL(refreshClicked()),this,SIGNAL(refreshClicked()));
    QObject::connect(qmlObject,SIGNAL(facebookClicked()),this,SIGNAL(facebookClicked()));
    QObject::connect(qmlObject,SIGNAL(configClicked()),this,SIGNAL(configClicked()));
    QObject::connect(qmlObject,SIGNAL(facebookClicked()),this,SIGNAL(facebookClicked()));
    QObject::connect(qmlObject,SIGNAL(needLocation()),this,SIGNAL(needLocation()));
    QObject::connect(qmlObject,SIGNAL(dontNeedLocation()),this,SIGNAL(dontNeedLocation()));
    QObject::connect(qmlObject,SIGNAL(submitClicked(QString)),this,SIGNAL(submitClicked(QString)));
    QObject::connect(qmlObject,SIGNAL(submitCheckinClicked(QString,QString,qreal,qreal)),this,SLOT(submitCheckinClickedSlot(QString,QString,qreal,qreal)));
    QObject::connect(qmlObject,SIGNAL(needPlaces(qreal,qreal)),this,SIGNAL(needPlaces(qreal,qreal)));

    //Complex signals

    //Expose slots
    QObject::connect(this,SIGNAL(setOldStatusSignal(QVariant)),qmlObject,SLOT(setOldStatus(QVariant)));
    QObject::connect(this,SIGNAL(clearStatusBoxSignal()),qmlObject,SLOT(clearStatusBox()));
    QObject::connect(this,SIGNAL(setGpsStatusSignal(QVariant)),qmlObject,SLOT(setGpsStatus(QVariant)));
    QObject::connect(this,SIGNAL(setLocationSignal(QVariant,QVariant)),qmlObject,SLOT(setLocation(QVariant,QVariant)));

}

//Public methods

void UiHelper::setGeometry(const QRect rect)
{
    view.setGeometry(rect);
}

void UiHelper::show()
{
    view.show();
}

void UiHelper::showMaximized()
{
    view.showMaximized();
}

//Public slots

void UiHelper::setOldStatus(QString status)
{
    emit setOldStatusSignal(QVariant(status));
}

void UiHelper::clearStatusBox()
{
    emit clearStatusBoxSignal();
}

void UiHelper::setGpsStatus(int status)
{
    emit setGpsStatusSignal(QVariant(status));
}

void UiHelper::setLocation(qreal latitude, qreal longitude)
{
    //qDebug()<<QString("Sending lat long to ui: %1, %2").arg(latitude).arg(longitude);
    emit setLocationSignal(QVariant(latitude),QVariant(longitude));
}

void UiHelper::setPlacesNearby(QList<Place *> places)
{
    placesListModel.clear();
    placesListModel.addPlaces(places);
}

void UiHelper::submitCheckinClickedSlot(QString status, QString placeId, qreal latitude, qreal longitude)
{
    emit submitCheckinClicked(status,placeId,latitude,longitude);
}

