 import Qt 4.7

Rectangle {id: main
    width: 800; height: 425
    color: "gray"

    signal refreshClicked;
    signal facebookClicked;
    signal mysteryClicked;
    signal submitClicked(string statusText);
    signal submitCheckinClicked(string statusText, string placeId, real latitude, real longitude)
    signal configClicked();
    signal needLocation();
    signal dontNeedLocation();
    signal needPlaces(real latitude, real longitude);

    function setOldStatus(oldStatusText) {
        currentStatus.statusText = oldStatusText;
    }

    function clearStatusBox() {
        newStatus.statusText = "";
        mainFlip.flipped = false;
    }

    function setGpsStatus(gpsStatus) {
        places.setGpsStatus(gpsStatus);
    }

    function setLocation(latitude, longitude) {
        places.setLocation(latitude, longitude);
    }

    property int squareSize : main.height/5
    property int leftColWidth : main.width - squareSize - 1
    property int bottomRowHeight : main.height - (4 * squareSize) - 1

    Grid {
        id: mainGrid
        rows: 5
        columns: 2
        anchors.fill : parent;

        Rectangle {width:leftColWidth;height:squareSize}
        BlackButton{id:refreshButton
            label:""
            image_source: "refresh.png"
            width: squareSize
            height: squareSize
            onBlackButtonClicked: {
                if (mainFlip.flipped)
                {
                    places.refreshPlacesList();
                    places.selectedPlaceId="";
                }
                else refreshClicked();
            }
        }
        Rectangle {width:leftColWidth;height:squareSize}
        BlackButton{id:facebookButton
            label:""
            image_source: "eff.png"
            width: squareSize
            height: squareSize
            onBlackButtonClicked: facebookClicked()
        }
        Rectangle {width:leftColWidth;height:squareSize}
        BlackButton{id:buttonConfig
            label:""
            image_source: "gear.png"
            width: squareSize
            height: squareSize
            onBlackButtonClicked: configClicked()
        }
        Rectangle {width:leftColWidth;height:squareSize}
        BlackButton{id:mysteryButton
            label:""
            image_source: "compass.png"
            width: squareSize
            height: squareSize
            onBlackButtonClicked: {
                mainFlip.flipped = !mainFlip.flipped;
            }
        }
        NewStatus {
            id: newStatus
            height: bottomRowHeight
            width: leftColWidth
            statusText: ""
        }
        BlackButton{id:submitButton;
            label:""
            image_source: "transmit.png"
            width: squareSize
            height: bottomRowHeight
            onBlackButtonClicked: {
                if (mainFlip.flipped) {
                    submitCheckinClicked(newStatus.statusText,places.selectedPlaceId,places.latitude,places.longitude);
                }
                else submitClicked(newStatus.statusText)
            }
        }
    }

    Rectangle {
        height: 4 * squareSize
        width: leftColWidth
        clip: true
        Image {
            source: "ENIAC_Penn2.jpg"
            anchors.bottom: parent.bottom
            anchors.left: parent.left
        }
    }

    Flipable {
        id: mainFlip
        height: 4 * squareSize
        width: leftColWidth

        property bool flipped: false


        front: CurrentStatus {
            id: currentStatus
            statusText: ""
            height: parent.height
            width: parent.width
        }

        back: Places {
            id: places
            height: parent.height
            width: parent.width
            onNeedLocation: {needLocation();}
            onNeedPlaces: {main.needPlaces(latitude,longitude);}
            listModel: qtPlacesListModel
        }

        transform: Rotation {
                 id: rotation
                 origin.x: mainFlip.width/2
                 origin.y: mainFlip.height/2
                 axis.x: 0; axis.y: 1; axis.z: 0     // set axis.y to 1 to rotate around y-axis
                 angle: 0    // the default angle
        }

        states: [State {
            name: "back"
            PropertyChanges { target: rotation; angle: 180 }
            when: mainFlip.flipped
            StateChangeScript {
                script: main.needLocation();
            }
        },State {
            name: "front"
            PropertyChanges { target: rotation; angle: 0 }
            when: !mainFlip.flipped
            StateChangeScript {
                script: {
                    main.dontNeedLocation();
                    main.refreshClicked();
                }
            }
        }]

        transitions: Transition {
            NumberAnimation { target: rotation; property: "angle"; duration: 750 }
        }
    }

}
