import Qt 4.7

Rectangle {
    id: placesMain
    width: 500
    height: 300
    clip: true

    signal needLocation;

    function setLocation(latitude,longitude) {
        placesMain.latitude = latitude;
        placesMain.longitude = longitude;
    }

    function refreshPlacesList() {
        needPlaces(placesMain.latitude,placesMain.longitude);
    }

    signal needPlaces(real latitude, real longitude);

    property real longitude: 0;
    property real latitude: 0;
    property alias selectedPlaceId : placesList.selectedPlaceId
    property alias listModel: placesList.listModel
//    property int cylonBarDuration: 2500

    function setGpsStatus(status) {
        if (status==-1) gpsStatus.state = 'error';
        if (status==0) gpsStatus.state = 'unavailable';
        if (status==1) gpsStatus.state = 'ready';
        if (status==2) gpsStatus.state = 'searching';
        if (status==3) gpsStatus.state = 'success';
    }

    Rectangle {
        id: gpsStatus
        anchors.top: parent.top
        anchors.horizontalCenter: parent.horizontalCenter
        height: textItem.height
        width: parent.width
        color: "grey"

        Item {
            id: textItem
            width: label.width + statusText.width
            height: label.height
            anchors.horizontalCenter: parent.horizontalCenter
            Text {
                id: label
                text: "GPS Status: "
                color: "white"
            }

            Text {
                id: statusText
                text: "???"
                anchors.left : label.right;
                color: "white"
            }
        }
        states: [
            State {
                name: "ready"
                PropertyChanges {target: statusText; text: "ready"}
            },
            State {
                name: "unavailable"
                PropertyChanges {target: statusText; text: "unavailable"}
            },
            State {
                name: "searching"
                PropertyChanges {target: statusText; text: "searching"}
            },
            State {
                name: "success"
                PropertyChanges {target: statusText; text: "success"}
                StateChangeScript {
                    script: needPlaces(placesMain.latitude,placesMain.longitude);
                }
            },
            State {
                name: "error"
                PropertyChanges {target: statusText; text: "error"}
            }
        ]
    }

    PlacesList {
        id: placesList
        anchors.top: gpsStatus.bottom;
        anchors.horizontalCenter:parent.horizontalCenter;
        width: parent.width
        height: parent.height - gpsStatus.height;
    }

//    Rectangle {
//        id:redVertical
//        color: "red"
//        height: parent.height;
//        width: 2
//        x:0
//        y:0
//        opacity: 0.75
//    }

//    Rectangle {
//        id:redHorizontal
//        color: "red"
//        height: 2
//        width: parent.width
//        x:0
//        y:0
//        opacity: 0.75
//    }

//    SequentialAnimation {
//        id: cylonBar
//        NumberAnimation {
//            target: redVertical
//            property: "x"
//            from: -2
//            to: parent.width + 2
//            duration: cylonBarDuration
//        }
//        NumberAnimation {
//            target: redHorizontal
//            property: "y"
//            from: - 2
//            to: parent.height + 2
//            duration: cylonBarDuration
//        }
//        NumberAnimation {
//            target: redVertical
//            property: "x"
//            from: parent.width + 2
//            to: -2
//            duration: cylonBarDuration
//        }
//        NumberAnimation {
//            target: redHorizontal
//            property: "y"
//            from: parent.height + 2
//            to: -2
//            duration: cylonBarDuration
//        }
//        loops: Animation.Infinite;
//        running:true;
//    }

}
