import Qt 4.7

Rectangle {id: currentStatusMain
    height: 300
    width: 500;
    gradient: Gradient {
         GradientStop { position: 0.0; color: "gray" }
         GradientStop { position: 1.0; color: "black" }
    }

    Text {id: watermark;
        anchors.horizontalCenter: parent.horizontalCenter;
        anchors.verticalCenter: parent.verticalCenter;
        text:"old status";
        font.family: "Arial, Helvetica, Sans-Serif";
        color:"black";
        font.pixelSize: parent.height/4
        font.weight: Font.Black;
        opacity: 0.5;
    }

    SequentialAnimation {
        id: watermark_animation;
        NumberAnimation {
            target: watermark; properties: "opacity";
            from: 0.1; to: 0.5; duration: 7500;
            easing.type: "OutExpo";
        }
        NumberAnimation {
            target: watermark; properties: "opacity";
            from: 0.5; to: 0.1; duration: 7500;
            easing.type: "OutExpo";
        }
        loops: Animation.Infinite

        running:true;
    }

    Flickable {id: currentStatusFlick
        clip:true;
        contentHeight: currentStatus.height;
        anchors.fill: currentStatusMain;
        Text { id: currentStatus;
            width: parent.width;
            text: statusText
            font.family: "Arial, Helvetica, Sans-Serif";
            color: "white";
            wrapMode: Text.Wrap;
            }
    }

    property string statusText: "<p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p>"
}
